/*
 * Decompiled with CFR 0.152.
 */
package io.protop.gradle.plugin;

import io.protop.gradle.plugin.ProtopExtension;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.Exec;

public class ProtopGradlePlugin
implements Plugin<Project> {
    public void apply(Project project) {
        ProtopExtension extension = (ProtopExtension)project.getExtensions().create("protop", ProtopExtension.class, new Object[0]);
        this.registerProtopClean(project);
        this.registerProtopSync(project, extension);
    }

    private void registerProtopClean(Project project) {
        project.getTasks().register("protopClean", Delete.class, delete -> this.protopClean(project, (Delete)delete));
    }

    private void protopClean(Project project, Delete delete) {
        Path path = Paths.get(project.getProjectDir().getAbsolutePath(), ".protop");
        delete.delete(new Object[]{path});
    }

    private void registerProtopSync(Project project, ProtopExtension extension) {
        project.getTasks().register("protopSync", Exec.class, exec -> {
            this.protopSync((Exec)exec, extension);
            exec.doLast(s -> System.out.println("Protop sync succeeded"));
        });
    }

    private void protopSync(Exec exec, ProtopExtension extension) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("protop");
        args.add("sync");
        if (extension.refreshGitSources) {
            args.add("--git-refresh");
        }
        if (extension.useLinks) {
            args.add("--use-links");
        }
        exec.commandLine(args);
    }
}

