/*
 * Decompiled with CFR 0.152.
 */
package io.proofdock.reliability.platform.spring;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.proofdock.reliability.platform.core.Chaos;
import io.proofdock.reliability.platform.core.MessageHandler;
import io.proofdock.reliability.platform.core.StringUtil;
import io.proofdock.reliability.platform.core.model.AttackContext;
import io.proofdock.reliability.platform.core.model.AttackSchema;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class ChaosInterceptor
extends HandlerInterceptorAdapter {
    private static Logger log = LoggerFactory.getLogger(ChaosInterceptor.class);
    private final String ATTACK_HEADER = "x-proofdock-attack";
    private Chaos chaos;

    public ChaosInterceptor(Chaos chaos) {
        this.chaos = chaos;
    }

    public boolean preHandle(HttpServletRequest requestServlet, HttpServletResponse responseServlet, Object handler) throws Exception {
        AttackContext context = new AttackContext();
        context.setType("java.spring.request");
        Map<String, String> params = Collections.singletonMap("route", requestServlet.getRequestURI());
        context.setParams(params);
        String chaosHeader = requestServlet.getHeader("x-proofdock-attack");
        AttackSchema schema = null;
        if (!StringUtil.isBlankOrEmpty((String)chaosHeader)) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                schema = (AttackSchema)mapper.readValue(chaosHeader, AttackSchema.class);
            }
            catch (IOException e) {
                log.error(MessageHandler.get((String)"chaos.attack.invalidheader"), (Throwable)e);
            }
        }
        this.chaos.attack(context);
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception exception) throws Exception {
    }
}

