/*
 * Decompiled with CFR 0.152.
 */
package io.proofdock.reliability.platform.spring;

import io.proofdock.reliability.platform.core.AppConfig;
import io.proofdock.reliability.platform.core.Chaos;
import io.proofdock.reliability.platform.core.MessageHandler;
import io.proofdock.reliability.platform.spring.ChaosProperties;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={ChaosProperties.class})
public class ChaosConfiguration {
    private static Logger log = LoggerFactory.getLogger(ChaosConfiguration.class);
    @Autowired
    ChaosProperties properties;

    @Bean
    public Chaos chaosService() {
        try {
            Chaos chaos = Chaos.getInstance();
            chaos.register((AppConfig)this.properties, Collections.singletonList("java.spring.request"));
            return chaos;
        }
        catch (Exception e) {
            log.error(MessageHandler.get((String)"chaos.register.exception"), (Throwable)e);
            return null;
        }
    }
}

