package io.proofdock.reliability.platform.spring;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;

import org.springframework.boot.context.properties.ConfigurationProperties;

import io.proofdock.reliability.platform.core.AppConfig;

@ConfigurationProperties(prefix = "reliability.platform")
public class ChaosProperties extends AppConfig {

    private String applicationEnv;
    private String applicationId;
    private String applicationName;
    private String attackLoader;
    private String proofdockApiUrl;
    private String proofdockApiToken;
    private Map<String, Supplier<String>> propertiesMapping;

    public String getApplicationEnv() {
        return this.applicationEnv;
    }

    public void setApplicationEnv(final String applicationEnv) {
        this.applicationEnv = applicationEnv;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(final String applicationId) {
        this.applicationId = applicationId;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(final String applicationName) {
        this.applicationName = applicationName;
    }

    public String getAttackLoader() {
        return this.attackLoader;
    }

    public void setAttackLoader(final String attackLoader) {
        this.attackLoader = attackLoader;
    }

    public String getProofdockApiToken() {
        return this.proofdockApiToken;
    }

    public void setProofdockApiToken(final String proofdockApiToken) {
        this.proofdockApiToken = proofdockApiToken;
    }

    public String getProofdockApiUrl() {
        return this.proofdockApiUrl;
    }

    public void setProofdockApiUrl(final String proofdockApiUrl) {
        this.proofdockApiUrl = proofdockApiUrl;
    }  

    public ChaosProperties() {
        propertiesMapping = new HashMap<String, Supplier<String>>();
        propertiesMapping.put(APPLICATION_ENV, this::getApplicationEnv);
        propertiesMapping.put(APPLICATION_ID, this::getApplicationId);
        propertiesMapping.put(APPLICATION_NAME, this::getApplicationName);
        propertiesMapping.put(ATTACK_LOADER, this::getAttackLoader);
        propertiesMapping.put(PROOFDOCK_API_URL, this::getProofdockApiUrl);
        propertiesMapping.put(PROOFDOCK_API_TOKEN, this::getProofdockApiToken);
        this.setApplicationId(UUID.randomUUID().toString());
    }
    @Override
    public String get(final String item, final String dflt) {
        if (!propertiesMapping.containsKey(item)) {
            return dflt;
        }
        return Optional.ofNullable(propertiesMapping.get(item).get()).orElse(dflt);
    }

}
