package io.proofdock.reliability.platform.spring;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;


@Configuration
@Import(ChaosConfiguration.class)
public class ChaosInterceptorConfiguration implements WebMvcConfigurer {

    @Autowired
    private ChaosConfiguration chaosConfiguration;

    @Override
    public void addInterceptors(InterceptorRegistry registry){
        registry.addInterceptor(new ChaosInterceptor(chaosConfiguration.chaosService()));
    }
    
}
