package io.proofdock.reliability.platform.spring;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.fasterxml.jackson.databind.ObjectMapper;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

import io.proofdock.reliability.platform.core.Chaos;
import io.proofdock.reliability.platform.core.MessageHandler;
import io.proofdock.reliability.platform.core.StringUtil;
import io.proofdock.reliability.platform.core.model.AttackContext;
import io.proofdock.reliability.platform.core.model.AttackSchema;

public class ChaosInterceptor extends HandlerInterceptorAdapter {
    private static Logger log = LoggerFactory.getLogger(ChaosInterceptor.class);
    private final String ATTACK_HEADER = "x-proofdock-attack";

    private Chaos chaos;

    public ChaosInterceptor(Chaos chaos) {
        this.chaos = chaos;
    }

    @Override
    public boolean preHandle(HttpServletRequest requestServlet, HttpServletResponse responseServlet, Object handler)
            throws Exception {
        // set attack context
        AttackContext context = new AttackContext();
        context.setType("java.spring.request");
        Map<String, String> params = Collections.singletonMap("route", requestServlet.getRequestURI());;
        context.setParams(params);

        String chaosHeader = requestServlet.getHeader(ATTACK_HEADER);
        AttackSchema schema = null;
        if (!StringUtil.isBlankOrEmpty(chaosHeader)) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                schema = mapper.readValue(chaosHeader, AttackSchema.class);
            } catch (IOException e) {
                log.error(MessageHandler.get("chaos.attack.invalidheader"), e);
            }
        }
        chaos.attack(context);
        return true;
    }

    @Override
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler,
            ModelAndView modelAndView) throws Exception {
    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler,
            Exception exception) throws Exception {
    }
}
