/*
 * Decompiled with CFR 0.152.
 */
package io.proofdock.chaos.middleware.spring;

import io.proofdock.chaos.middleware.core.AppConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="chaos.middleware")
public class ChaosProperties
extends AppConfig {
    private String applicationEnv;
    private String applicationId;
    private String applicationName;
    private String attackLoader;
    private String proofdockApiUrl;
    private String proofdockApiToken;
    private Map<String, Supplier<String>> propertiesMapping = new HashMap<String, Supplier<String>>();

    public String getApplicationEnv() {
        return this.applicationEnv;
    }

    public void setApplicationEnv(String applicationEnv) {
        this.applicationEnv = applicationEnv;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getAttackLoader() {
        return this.attackLoader;
    }

    public void setAttackLoader(String attackLoader) {
        this.attackLoader = attackLoader;
    }

    public String getProofdockApiToken() {
        return this.proofdockApiToken;
    }

    public void setProofdockApiToken(String proofdockApiToken) {
        this.proofdockApiToken = proofdockApiToken;
    }

    public String getProofdockApiUrl() {
        return this.proofdockApiUrl;
    }

    public void setProofdockApiUrl(String proofdockApiUrl) {
        this.proofdockApiUrl = proofdockApiUrl;
    }

    public ChaosProperties() {
        this.propertiesMapping.put("CHAOS_MIDDLEWARE_APPLICATION_ENV", this::getApplicationEnv);
        this.propertiesMapping.put("CHAOS_MIDDLEWARE_APPLICATION_ID", this::getApplicationId);
        this.propertiesMapping.put("CHAOS_MIDDLEWARE_APPLICATION_NAME", this::getApplicationName);
        this.propertiesMapping.put("CHAOS_MIDDLEWARE_ATTACK_LOADER", this::getAttackLoader);
        this.propertiesMapping.put("CHAOS_MIDDLEWARE_PROOFDOCK_API_URL", this::getProofdockApiUrl);
        this.propertiesMapping.put("CHAOS_MIDDLEWARE_PROOFDOCK_API_TOKEN", this::getProofdockApiToken);
        this.setApplicationId(UUID.randomUUID().toString());
    }

    public String get(String item, String dflt) {
        if (!this.propertiesMapping.containsKey(item)) {
            return dflt;
        }
        return Optional.ofNullable(this.propertiesMapping.get(item).get()).orElse(dflt);
    }
}

