package io.proofdock.chaos.middleware.spring;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import io.proofdock.chaos.middleware.core.Chaos;
import io.proofdock.chaos.middleware.core.MessageHandler;

@Configuration
@EnableConfigurationProperties(ChaosProperties.class)
public class ChaosConfiguration {
  private static Logger log = LoggerFactory.getLogger(ChaosConfiguration.class);

  @Autowired
  ChaosProperties properties;

  @Bean
  public Chaos chaosService() {
    try {
      Chaos chaos = Chaos.getInstance();
      chaos.register(properties);
      return chaos;
    } catch (Exception e) {
      log.error(MessageHandler.get("chaos.register.exception"), e);
      return null;
    }
  }
}
