package io.proofdock.chaos.middleware.spring;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.fasterxml.jackson.databind.ObjectMapper;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

import io.proofdock.chaos.middleware.core.Chaos;
import io.proofdock.chaos.middleware.core.MessageHandler;
import io.proofdock.chaos.middleware.core.StringUtil;
import io.proofdock.chaos.middleware.core.model.AttackContext;
import io.proofdock.chaos.middleware.core.model.AttackSchema;

public class ChaosInterceptor extends HandlerInterceptorAdapter {
    private static Logger log = LoggerFactory.getLogger(ChaosInterceptor.class);
    private final String ATTACK_HEADER = "x-proofdock-attack";

    private Chaos chaos;

    public ChaosInterceptor(Chaos chaos) {
        this.chaos = chaos;
    }

    @Override
    public boolean preHandle(HttpServletRequest requestServlet, HttpServletResponse responseServlet, Object handler)
            throws Exception {
        // set attack context
        AttackContext context = new AttackContext();
        context.setRoute(requestServlet.getRequestURI());

        String chaosHeader = requestServlet.getHeader(ATTACK_HEADER);
        AttackSchema schema = null;
        if (!StringUtil.isBlankOrEmpty(chaosHeader)) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                schema = mapper.readValue(chaosHeader, AttackSchema.class);
            } catch (IOException e) {
                log.error(MessageHandler.get("chaos.attack.invalidheader"), e);
            }
        }
        chaos.attack(schema, context);
        return true;
    }

    @Override
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler,
            ModelAndView modelAndView) throws Exception {
    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler,
            Exception exception) throws Exception {
    }
}
