/*
 * Decompiled with CFR 0.152.
 */
package io.proofdock.reliability.platform.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageHandler {
    private static Logger log = LoggerFactory.getLogger(MessageHandler.class);
    private static MessageHandler instance;
    private final Properties props = new Properties();

    private MessageHandler() {
        try {
            ClassLoader classloader = Thread.currentThread().getContextClassLoader();
            InputStream is = classloader.getResourceAsStream("messages.properties");
            this.props.load(is);
        }
        catch (IOException e) {
            log.error("Unable to read message properties. Log information will be empty from now on. Reason: " + e.getMessage());
        }
    }

    private static MessageHandler getInstance() {
        if (instance == null) {
            instance = new MessageHandler();
        }
        return instance;
    }

    public static String get(String key) {
        return MessageHandler.getInstance().getOrDefault(key);
    }

    private String getOrDefault(String key) {
        return this.props.getProperty(key, key);
    }
}

