/*
 * Decompiled with CFR 0.152.
 */
package io.proofdock.reliability.platform.core;

import io.proofdock.reliability.platform.core.MessageHandler;
import io.proofdock.reliability.platform.core.error.ReliabilityPlatformError;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Inject {
    private static Logger log = LoggerFactory.getLogger(Inject.class);

    public void delay(String inputSeconds) {
        try {
            int seconds = Integer.parseInt(inputSeconds);
            if (seconds > 0) {
                log.debug(String.format(MessageHandler.get("inject.delay.attack"), inputSeconds));
                long millis = seconds * 1000;
                Thread.sleep(millis);
            } else {
                log.warn(MessageHandler.get("inject.delay.skip"));
            }
        }
        catch (NumberFormatException nfe) {
            log.warn(MessageHandler.get("inject.delay.skip") + " Reason: " + nfe.getMessage());
        }
        catch (InterruptedException ie) {
            log.warn(MessageHandler.get("inject.delay.skip") + " Reason: " + ie.getMessage());
        }
    }

    public void fault(String inputException) throws Exception {
        Object searchedException = null;
        try {
            searchedException = Class.forName(inputException).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            log.error(String.format(MessageHandler.get("inject.fault.notinstantiated") + " Reason: " + e.getMessage(), inputException));
            log.warn(MessageHandler.get("inject.fault.alternativeattack"));
            throw new ReliabilityPlatformError();
        }
        Exception ex = searchedException;
        log.debug(String.format(MessageHandler.get("inject.fault.attack"), inputException));
        throw new ReliabilityPlatformError(ex);
    }
}

