/*
 * Decompiled with CFR 0.152.
 */
package io.proofdock.reliability.platform.core;

import io.proofdock.reliability.platform.core.MessageHandler;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dice {
    private static Logger log = LoggerFactory.getLogger(Dice.class);

    public static boolean roll(Integer inputProbability) {
        int min = 1;
        int max = 100;
        if (inputProbability == null) {
            return true;
        }
        try {
            int probability = inputProbability;
            if (inputProbability == 100) {
                return true;
            }
            if (min <= probability && probability <= max) {
                int rolledValue = new Random().nextInt(max + 1);
                return rolledValue <= probability;
            }
            log.warn(String.format(MessageHandler.get("dice.roll"), probability, "out of range"));
            return false;
        }
        catch (NumberFormatException nfe) {
            log.warn(String.format(MessageHandler.get("dice.roll"), inputProbability, "invalid"));
            return false;
        }
    }
}

