/*
 * Decompiled with CFR 0.152.
 */
package io.proofdock.reliability.platform.core;

import io.proofdock.reliability.platform.core.AppConfig;
import io.proofdock.reliability.platform.core.Dice;
import io.proofdock.reliability.platform.core.Inject;
import io.proofdock.reliability.platform.core.MessageHandler;
import io.proofdock.reliability.platform.core.StringUtil;
import io.proofdock.reliability.platform.core.error.ReliabilityPlatformError;
import io.proofdock.reliability.platform.core.loader.AttackLoader;
import io.proofdock.reliability.platform.core.model.AttackActionSchema;
import io.proofdock.reliability.platform.core.model.AttackContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Chaos {
    private static Logger log = LoggerFactory.getLogger(Chaos.class);
    public static final String ATTACK_ACTION_FAULT = "fault";
    public static final String ATTACK_ACTION_DELAY = "delay";
    private static Chaos instance;
    private AppConfig config;
    private AttackLoader attackLoader;
    private List<AttackActionSchema> loadedActions;
    private List<String> attackCapabilities;
    private Inject inject = new Inject();

    private Chaos() {
        this.loadedActions = new ArrayList<AttackActionSchema>();
        this.attackCapabilities = new ArrayList<String>();
    }

    public static Chaos getInstance() {
        if (instance == null) {
            instance = new Chaos();
        }
        return instance;
    }

    public void register(AppConfig config, List<String> attackCapabilities) throws Exception {
        assert (config != null);
        if (attackCapabilities != null && !attackCapabilities.isEmpty()) {
            this.attackCapabilities = attackCapabilities;
        }
        if (this.config == null) {
            this.config = config;
            this.attackLoader = AttackLoader.get(config);
            if (this.attackLoader != null) {
                this.attackLoader.load();
            }
        }
    }

    public void deregister() {
        this.config = null;
    }

    public void unloadAttacks() {
        this.loadedActions = new ArrayList<AttackActionSchema>();
    }

    public void loadAttacks(List<AttackActionSchema> actionSchemas) {
        this.loadedActions = actionSchemas;
    }

    public List<String> getAttackCapabilities() {
        return this.attackCapabilities;
    }

    public void attack(AttackContext attackContext) throws Exception {
        try {
            this.updateAttackCapabilities(attackContext);
            this.executeAttacks(this.loadedActions, attackContext);
        }
        catch (ReliabilityPlatformError error) {
            log.debug(MessageHandler.get("chaos.attack.chaosmiddlewareerror"));
            if (error.getCause() != null) {
                throw (Exception)error.getCause();
            }
            throw error;
        }
        catch (Exception e) {
            log.error(MessageHandler.get("chaos.attack.exception"), (Throwable)e);
        }
    }

    private void executeAttacks(List<AttackActionSchema> actions, AttackContext attackContext) throws Exception {
        for (AttackActionSchema action : actions) {
            if (!this.isTypeValid(action.getType(), attackContext.getType()) || !this.areParamsValid(action.getParams(), attackContext.getParams()) || !this.isLuckyToBeAttacked(action.getProbability())) continue;
            if (action.getName().equals(ATTACK_ACTION_DELAY)) {
                this.inject.delay(action.getValue());
            }
            if (!action.getName().equals(ATTACK_ACTION_FAULT)) continue;
            this.inject.fault(action.getValue());
        }
    }

    private boolean isLuckyToBeAttacked(Integer probability) {
        boolean isLucky = Dice.roll(probability);
        return isLucky;
    }

    private boolean isTypeValid(String attackType, String ctxType) {
        if (StringUtil.isBlankOrEmpty(attackType) || StringUtil.isBlankOrEmpty(ctxType)) {
            return false;
        }
        return attackType.equals(ctxType);
    }

    private boolean areParamsValid(Map<String, String> attackParams, Map<String, String> ctxParams) {
        Iterator<Map.Entry<String, String>> iterator = attackParams.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<String, String> param = iterator.next();
            if (!ctxParams.containsKey(param.getKey()) || StringUtil.isBlankOrEmpty(ctxParams.get(param.getKey()))) {
                return false;
            }
            String attackParamValue = param.getValue();
            attackParamValue = StringUtil.isBlankOrEmpty(attackParamValue) ? ".*" : attackParamValue.replace("*", ".*");
            Pattern pattern = Pattern.compile(attackParamValue);
            Matcher matcher = pattern.matcher(ctxParams.get(param.getKey()));
            boolean result = matcher.find();
            return result;
        }
        return true;
    }

    private void updateAttackCapabilities(AttackContext context) {
        if (!StringUtil.isBlankOrEmpty(context.getType()) && !this.attackCapabilities.contains(context.getType())) {
            this.attackCapabilities.add(context.getType());
        }
    }
}

