/*
 * Decompiled with CFR 0.152.
 */
package io.proofdock.chaos.middleware.core.loader;

import io.proofdock.chaos.middleware.core.AppConfig;
import io.proofdock.chaos.middleware.core.MessageHandler;
import io.proofdock.chaos.middleware.core.loader.proofdock.ProofdockAttackLoader;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AttackLoader {
    private static Logger log = LoggerFactory.getLogger(AttackLoader.class);
    private static final String DEFAULT_LOADER = "proofdock";
    protected AppConfig appConfig;
    private ScheduledExecutorService scheduledThreadPool = Executors.newScheduledThreadPool(1);

    public AttackLoader(AppConfig appConfig) {
        this.appConfig = appConfig;
    }

    protected abstract boolean isAllowedToCallEndpoint();

    public void load() throws Exception {
        if (!this.isAllowedToCallEndpoint()) {
            throw new Exception(MessageHandler.get("attackloader.load.throwexception"));
        }
        Runnable task = this.createTask();
        this.scheduledThreadPool.scheduleAtFixedRate(task, 0L, 30L, TimeUnit.SECONDS);
    }

    protected abstract Runnable createTask();

    public static AttackLoader get(AppConfig app_config) {
        String provider = app_config.get("CHAOS_MIDDLEWARE_ATTACK_LOADER", DEFAULT_LOADER);
        ProofdockAttackLoader loader = null;
        if (provider.equals(DEFAULT_LOADER)) {
            loader = new ProofdockAttackLoader(app_config);
        } else {
            log.warn(String.format(MessageHandler.get("attackloader.get.noproperloader"), provider));
        }
        if (loader != null && !((AttackLoader)loader).isAllowedToCallEndpoint()) {
            log.info(String.format(MessageHandler.get("attackloader.get.noconfig"), provider));
            loader = null;
        }
        return loader;
    }
}

