package io.proofdock.chaos.middleware.core.loader.proofdock;

import io.proofdock.chaos.middleware.core.AppConfig;
import io.proofdock.chaos.middleware.core.StringUtil;
import io.proofdock.chaos.middleware.core.loader.AttackLoader;

public class ProofdockAttackLoader extends AttackLoader {

  public ProofdockAttackLoader(AppConfig appConfig) {
    super(appConfig);
  }

  @Override
  protected boolean isAllowedToCallEndpoint() {
    String token = this.appConfig.get(AppConfig.PROOFDOCK_API_TOKEN, "");
    String name = this.appConfig.get(AppConfig.APPLICATION_NAME, "");
    String id = this.appConfig.get(AppConfig.APPLICATION_ID, "");

    return !StringUtil.isBlankOrEmpty(token) && !StringUtil.isBlankOrEmpty(name) && !StringUtil.isBlankOrEmpty(id);
  }

  @Override
  protected Runnable createTask() {
    return new ProofdockAttackLoaderTask(this.appConfig);
  }
}
