/*
 * Decompiled with CFR 0.152.
 */
package io.proofdock.chaos.middleware.core;

import io.proofdock.chaos.middleware.core.AppConfig;
import io.proofdock.chaos.middleware.core.Dice;
import io.proofdock.chaos.middleware.core.Inject;
import io.proofdock.chaos.middleware.core.MessageHandler;
import io.proofdock.chaos.middleware.core.StringUtil;
import io.proofdock.chaos.middleware.core.error.ChaosMiddlewareError;
import io.proofdock.chaos.middleware.core.loader.AttackLoader;
import io.proofdock.chaos.middleware.core.model.AttackActionSchema;
import io.proofdock.chaos.middleware.core.model.AttackContext;
import io.proofdock.chaos.middleware.core.model.AttackSchema;
import io.proofdock.chaos.middleware.core.model.AttackTargetSchema;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Chaos {
    private static Logger log = LoggerFactory.getLogger(Chaos.class);
    public static final String ATTACK_ACTION_FAULT = "fault";
    public static final String ATTACK_ACTION_DELAY = "delay";
    private static Chaos instance;
    private AppConfig config;
    private AttackLoader attackLoader;
    private List<AttackActionSchema> loadedActions;
    private Inject inject = new Inject();

    private Chaos() {
        this.loadedActions = new ArrayList<AttackActionSchema>();
    }

    public static Chaos getInstance() {
        if (instance == null) {
            instance = new Chaos();
        }
        return instance;
    }

    public void register(AppConfig config) throws Exception {
        assert (config != null);
        if (this.config == null) {
            this.config = config;
            this.attackLoader = AttackLoader.get(config);
            this.attackLoader.load();
        }
    }

    public void deregister() {
        this.config = null;
    }

    public void unloadAttacks() {
        this.loadedActions = new ArrayList<AttackActionSchema>();
    }

    public void loadAttacks(List<AttackActionSchema> actionSchemas) {
        this.loadedActions = actionSchemas;
    }

    public void attack(AttackSchema attackInput, AttackContext attackContext) throws Exception {
        try {
            if (attackInput != null) {
                this.execute_attacks(attackInput.getTarget(), attackInput.getActions(), attackContext);
            } else if (this.loadedActions.size() > 0) {
                this.execute_attacks(null, this.loadedActions, attackContext);
            }
        }
        catch (ChaosMiddlewareError cme) {
            log.debug(MessageHandler.get("chaos.attack.chaosmiddlewareerror"));
            if (cme.getCause() != null) {
                throw (Exception)cme.getCause();
            }
            throw cme;
        }
        catch (Exception e) {
            log.error(MessageHandler.get("chaos.attack.exception"), (Throwable)e);
        }
    }

    private void execute_attacks(AttackTargetSchema target, List<AttackActionSchema> actions, AttackContext attackContext) throws Exception {
        for (AttackActionSchema action : actions) {
            if (!this.isAppTargeted(target) || !this.isRouteTargeted(attackContext.getRoute(), action.getRoute()) || !this.isLuckyToBeAttacked(action.getProbability())) continue;
            if (action.getName().equals(ATTACK_ACTION_DELAY)) {
                this.inject.delay(action.getValue());
            }
            if (!action.getName().equals(ATTACK_ACTION_FAULT)) continue;
            this.inject.fault(action.getValue());
        }
    }

    private boolean isLuckyToBeAttacked(String probability) {
        boolean is_lucky = Dice.roll(probability);
        return is_lucky;
    }

    private boolean isRouteTargeted(String attackCtxRoute, String actionRoute) {
        if (StringUtil.isBlankOrEmpty(attackCtxRoute) || StringUtil.isBlankOrEmpty(actionRoute)) {
            return true;
        }
        String text = actionRoute.replace("/*", "/[\\w-]*");
        Pattern pattern = Pattern.compile(text);
        Matcher matcher = pattern.matcher(attackCtxRoute);
        boolean result = matcher.find();
        return result;
    }

    private boolean isAppTargeted(AttackTargetSchema target) {
        if (target == null) {
            return true;
        }
        String application = target.getApplication();
        String environment = target.getEnvironment();
        boolean isAppTargeted = StringUtil.isBlankOrEmpty(application) || !StringUtil.isBlankOrEmpty(application) && application.equals(this.config.get("CHAOS_MIDDLEWARE_APPLICATION_NAME", ""));
        boolean isEnvTargeted = StringUtil.isBlankOrEmpty(environment) || !StringUtil.isBlankOrEmpty(environment) && environment.equals(this.config.get("CHAOS_MIDDLEWARE_APPLICATION_ENV", ""));
        return isAppTargeted && isEnvTargeted;
    }
}

