package io.proofdock.chaos.middleware.core;

import io.proofdock.chaos.middleware.core.error.ChaosMiddlewareError;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Inject {

  private static Logger log = LoggerFactory.getLogger(Inject.class);

  /**
   * Delay the response
   *
   * @param inputSeconds delay in seconds
   */
  public void delay(String inputSeconds) {
    try {
      int seconds = Integer.parseInt(inputSeconds);
      if (seconds > 0) {
        log.debug(String.format(MessageHandler.get("inject.delay.attack"), inputSeconds));
        long millis = seconds * 1000;
        Thread.sleep(millis);
      } else {
        log.warn(MessageHandler.get("inject.delay.skip"));
      }
    } catch (NumberFormatException nfe) {
      log.warn(MessageHandler.get("inject.delay.skip") + " Reason: " + nfe.getMessage());
    } catch (InterruptedException ie) {
      log.warn(MessageHandler.get("inject.delay.skip") + " Reason: " + ie.getMessage());
    }
  }

  /**
   * Raise the exception from the passed fully qualified name. The exception is wrapped in a ChaosMiddlewareError and
   * gets raised.
   *
   * @param inputException name of the exception to throw (e.g java.lang.Exception)
   * @throws ChaosMiddlewareError error requested by the user
   */
  public void fault(String inputException) throws Exception {
    Object searchedException = null;
    try {
      searchedException = Class.forName(inputException).getDeclaredConstructor().newInstance();
    } catch (
        InstantiationException | IllegalAccessException |
            InvocationTargetException | NoSuchMethodException | ClassNotFoundException e) {
      log.error(String
          .format(MessageHandler.get("inject.fault.notinstantiated") + " Reason: " + e.getMessage(), inputException));
      log.warn(MessageHandler.get("inject.fault.alternativeattack"));
      throw new ChaosMiddlewareError();
    }

    Exception ex = (Exception) searchedException;
    log.debug(String.format(MessageHandler.get("inject.fault.attack"), inputException));
    throw new ChaosMiddlewareError(ex);

  }

}
