/*
 * Decompiled with CFR 0.152.
 */
package io.proofdock.chaos.middleware.core.loader.proofdock;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.proofdock.chaos.middleware.core.AppConfig;
import io.proofdock.chaos.middleware.core.Chaos;
import io.proofdock.chaos.middleware.core.MessageHandler;
import io.proofdock.chaos.middleware.core.model.AttackActionSchema;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProofdockAttackLoaderTask
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(ProofdockAttackLoaderTask.class);
    private static final String PROOFDOCK_API_DEFAULT_URL = "https://chaosapi.proofdock.io";
    private static final String PROOFDOCK_API_DEFAULT_ROUTE = "/v1/attacks/synchronize";
    private final ObjectMapper mapper;
    private final AppConfig appConfig;

    public ProofdockAttackLoaderTask(AppConfig appConfig) {
        this.appConfig = appConfig;
        this.mapper = new ObjectMapper();
    }

    @Override
    public void run() {
        try {
            StringEntity entity = this.createRequestBody(this.appConfig);
            String token = this.appConfig.get("CHAOS_MIDDLEWARE_PROOFDOCK_API_TOKEN", "");
            String targetUri = this.appConfig.get("CHAOS_MIDDLEWARE_PROOFDOCK_API_URL", PROOFDOCK_API_DEFAULT_URL);
            Response response = Request.Post((String)(targetUri + PROOFDOCK_API_DEFAULT_ROUTE)).addHeader("Authorization", "Bearer " + token).body((HttpEntity)entity).connectTimeout(13000).socketTimeout(13000).execute();
            HttpResponse httpResponse = response.returnResponse();
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode < 200 || statusCode >= 400) {
                throw new Exception(MessageHandler.get("attackloader.load.throwexception") + " Reason: Invalid status code returned from api loader: " + statusCode);
            }
            String content = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
            List<Object> actionSchemas = Arrays.asList((Object[])this.mapper.readValue(content, AttackActionSchema[].class));
            Chaos.getInstance().loadAttacks(actionSchemas);
        }
        catch (Exception e) {
            log.error(MessageHandler.get("proofdockattackloadertask.run.exception"), (Throwable)e);
            Chaos.getInstance().unloadAttacks();
        }
    }

    private StringEntity createRequestBody(AppConfig appConfig) throws UnsupportedEncodingException {
        String id = appConfig.get("CHAOS_MIDDLEWARE_APPLICATION_ID", "");
        String env = appConfig.get("CHAOS_MIDDLEWARE_APPLICATION_ENV", "");
        String name = appConfig.get("CHAOS_MIDDLEWARE_APPLICATION_NAME", "");
        String json = String.format("{\"id\":\"%s\",\"env\":\"%s\",\"name\":\"%s\"}", id, env, name);
        StringEntity result = new StringEntity(json);
        return result;
    }
}

