package io.proofdock.chaos.middleware.core;

import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dice {

  private static Logger log = LoggerFactory.getLogger(Dice.class);

  public static boolean roll(String inputProbability) {
    int min = 1, max = 100;
    if (StringUtil.isBlankOrEmpty(inputProbability)) {
      return true;
    }

    try {
      int probability = Integer.parseInt(inputProbability);
      if (probability == 100) {
        return true;
      } else if (min <= probability && probability <= max) {
        int rolledValue = new Random().nextInt(max + 1);
        return rolledValue <= probability;
      } else {
        log.warn(String.format(MessageHandler.get("dice.roll"), probability, "out of range"));
        return false;
      }
    } catch (NumberFormatException nfe) {
      log.warn(String.format(MessageHandler.get("dice.roll"), inputProbability, "invalid"));
      return false;
    }

  }
}
