/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.cloudwatch;

import io.prometheus.client.exporter.MetricsServlet;
import io.prometheus.cloudwatch.CloudWatchCollector;
import io.prometheus.cloudwatch.DynamicReloadServlet;
import io.prometheus.cloudwatch.HealthServlet;
import io.prometheus.cloudwatch.HomePageServlet;
import io.prometheus.cloudwatch.ReloadSignalHandler;
import java.io.FileReader;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class WebServer {
    public static String configFilePath;

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Usage: WebServer <port> <yml configuration file>");
            System.exit(1);
        }
        configFilePath = args[1];
        CloudWatchCollector collector = null;
        try (FileReader reader = null;){
            reader = new FileReader(configFilePath);
            collector = (CloudWatchCollector)new CloudWatchCollector(new FileReader(configFilePath)).register();
        }
        ReloadSignalHandler.start(collector);
        int port = Integer.parseInt(args[0]);
        Server server = new Server(port);
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/");
        server.setHandler((Handler)context);
        context.addServlet(new ServletHolder((Servlet)new MetricsServlet()), "/metrics");
        context.addServlet(new ServletHolder((Servlet)new DynamicReloadServlet(collector)), "/-/reload");
        context.addServlet(new ServletHolder((Servlet)new HealthServlet()), "/-/healthy");
        context.addServlet(new ServletHolder((Servlet)new HealthServlet()), "/-/ready");
        context.addServlet(new ServletHolder((Servlet)new HomePageServlet()), "/");
        server.start();
        server.join();
    }
}

