/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.cloudwatch;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchClientBuilder;
import com.amazonaws.services.cloudwatch.model.Datapoint;
import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.services.cloudwatch.model.DimensionFilter;
import com.amazonaws.services.cloudwatch.model.GetMetricStatisticsRequest;
import com.amazonaws.services.cloudwatch.model.GetMetricStatisticsResult;
import com.amazonaws.services.cloudwatch.model.ListMetricsRequest;
import com.amazonaws.services.cloudwatch.model.ListMetricsResult;
import com.amazonaws.services.cloudwatch.model.Metric;
import com.amazonaws.services.resourcegroupstaggingapi.AWSResourceGroupsTaggingAPI;
import com.amazonaws.services.resourcegroupstaggingapi.AWSResourceGroupsTaggingAPIClientBuilder;
import com.amazonaws.services.resourcegroupstaggingapi.model.GetResourcesRequest;
import com.amazonaws.services.resourcegroupstaggingapi.model.GetResourcesResult;
import com.amazonaws.services.resourcegroupstaggingapi.model.ResourceTagMapping;
import com.amazonaws.services.resourcegroupstaggingapi.model.Tag;
import com.amazonaws.services.resourcegroupstaggingapi.model.TagFilter;
import io.prometheus.client.Collector;
import io.prometheus.client.Counter;
import io.prometheus.cloudwatch.WebServer;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.Yaml;

public class CloudWatchCollector
extends Collector
implements Collector.Describable {
    private static final Logger LOGGER = Logger.getLogger(CloudWatchCollector.class.getName());
    ActiveConfig activeConfig = new ActiveConfig();
    private static final Counter cloudwatchRequests = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().labelNames(new String[]{"action", "namespace"})).name("cloudwatch_requests_total")).help("API requests made to CloudWatch")).register();
    private static final Counter taggingApiRequests = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().labelNames(new String[]{"action", "resource_type"})).name("tagging_api_requests_total")).help("API requests made to the Resource Groups Tagging API")).register();
    private static final List<String> brokenDynamoMetrics = Arrays.asList("ConsumedReadCapacityUnits", "ConsumedWriteCapacityUnits", "ProvisionedReadCapacityUnits", "ProvisionedWriteCapacityUnits", "ReadThrottleEvents", "WriteThrottleEvents");

    public CloudWatchCollector(Reader in) throws IOException {
        this.loadConfig(in, null, null);
    }

    public CloudWatchCollector(String yamlConfig) {
        this((Map)new Yaml().load(yamlConfig), null, null);
    }

    protected CloudWatchCollector(String jsonConfig, AmazonCloudWatch cloudWatchClient, AWSResourceGroupsTaggingAPI taggingClient) {
        this((Map)new Yaml().load(jsonConfig), cloudWatchClient, taggingClient);
    }

    private CloudWatchCollector(Map<String, Object> config, AmazonCloudWatch cloudWatchClient, AWSResourceGroupsTaggingAPI taggingClient) {
        this.loadConfig(config, cloudWatchClient, taggingClient);
    }

    public List<Collector.MetricFamilySamples> describe() {
        return Collections.emptyList();
    }

    protected void reloadConfig() throws IOException {
        LOGGER.log(Level.INFO, "Reloading configuration");
        try (FileReader reader = null;){
            reader = new FileReader(WebServer.configFilePath);
            this.loadConfig(reader, this.activeConfig.cloudWatchClient, this.activeConfig.taggingClient);
        }
    }

    protected void loadConfig(Reader in, AmazonCloudWatch cloudWatchClient, AWSResourceGroupsTaggingAPI taggingClient) throws IOException {
        this.loadConfig((Map)new Yaml().load(in), cloudWatchClient, taggingClient);
    }

    private void loadConfig(Map<String, Object> config, AmazonCloudWatch cloudWatchClient, AWSResourceGroupsTaggingAPI taggingClient) {
        AmazonCloudWatchClientBuilder clientBuilder;
        if (config == null) {
            config = new HashMap<String, Object>();
        }
        int defaultPeriod = 60;
        if (config.containsKey("period_seconds")) {
            defaultPeriod = ((Number)config.get("period_seconds")).intValue();
        }
        int defaultRange = 600;
        if (config.containsKey("range_seconds")) {
            defaultRange = ((Number)config.get("range_seconds")).intValue();
        }
        int defaultDelay = 600;
        if (config.containsKey("delay_seconds")) {
            defaultDelay = ((Number)config.get("delay_seconds")).intValue();
        }
        boolean defaultCloudwatchTimestamp = true;
        if (config.containsKey("set_timestamp")) {
            defaultCloudwatchTimestamp = (Boolean)config.get("set_timestamp");
        }
        String region = (String)config.get("region");
        if (cloudWatchClient == null) {
            clientBuilder = AmazonCloudWatchClientBuilder.standard();
            if (config.containsKey("role_arn")) {
                clientBuilder.setCredentials(this.getRoleCredentialProvider(config));
            }
            if (region != null) {
                clientBuilder.setRegion(region);
            }
            cloudWatchClient = (AmazonCloudWatch)clientBuilder.build();
        }
        if (taggingClient == null) {
            clientBuilder = AWSResourceGroupsTaggingAPIClientBuilder.standard();
            if (config.containsKey("role_arn")) {
                clientBuilder.setCredentials(this.getRoleCredentialProvider(config));
            }
            if (region != null) {
                clientBuilder.setRegion(region);
            }
            taggingClient = (AWSResourceGroupsTaggingAPI)clientBuilder.build();
        }
        if (!config.containsKey("metrics")) {
            throw new IllegalArgumentException("Must provide metrics");
        }
        ArrayList<MetricRule> rules = new ArrayList<MetricRule>();
        for (Object ruleObject : (List)config.get("metrics")) {
            AWSTagSelect awsTagSelect;
            Map yamlMetricRule = (Map)ruleObject;
            MetricRule rule = new MetricRule();
            rules.add(rule);
            if (!yamlMetricRule.containsKey("aws_namespace") || !yamlMetricRule.containsKey("aws_metric_name")) {
                throw new IllegalArgumentException("Must provide aws_namespace and aws_metric_name");
            }
            rule.awsNamespace = (String)yamlMetricRule.get("aws_namespace");
            rule.awsMetricName = (String)yamlMetricRule.get("aws_metric_name");
            if (yamlMetricRule.containsKey("help")) {
                rule.help = (String)yamlMetricRule.get("help");
            }
            if (yamlMetricRule.containsKey("aws_dimensions")) {
                rule.awsDimensions = (List)yamlMetricRule.get("aws_dimensions");
            }
            if (yamlMetricRule.containsKey("aws_dimension_select") && yamlMetricRule.containsKey("aws_dimension_select_regex")) {
                throw new IllegalArgumentException("Must not provide aws_dimension_select and aws_dimension_select_regex at the same time");
            }
            if (yamlMetricRule.containsKey("aws_dimension_select")) {
                rule.awsDimensionSelect = (Map)yamlMetricRule.get("aws_dimension_select");
            }
            if (yamlMetricRule.containsKey("aws_dimension_select_regex")) {
                rule.awsDimensionSelectRegex = (Map)yamlMetricRule.get("aws_dimension_select_regex");
            }
            if (yamlMetricRule.containsKey("aws_statistics")) {
                rule.awsStatistics = (List)yamlMetricRule.get("aws_statistics");
            } else if (!yamlMetricRule.containsKey("aws_extended_statistics")) {
                rule.awsStatistics = new ArrayList<String>(Arrays.asList("Sum", "SampleCount", "Minimum", "Maximum", "Average"));
            }
            if (yamlMetricRule.containsKey("aws_extended_statistics")) {
                rule.awsExtendedStatistics = (List)yamlMetricRule.get("aws_extended_statistics");
            }
            rule.periodSeconds = yamlMetricRule.containsKey("period_seconds") ? ((Number)yamlMetricRule.get("period_seconds")).intValue() : defaultPeriod;
            rule.rangeSeconds = yamlMetricRule.containsKey("range_seconds") ? ((Number)yamlMetricRule.get("range_seconds")).intValue() : defaultRange;
            rule.delaySeconds = yamlMetricRule.containsKey("delay_seconds") ? ((Number)yamlMetricRule.get("delay_seconds")).intValue() : defaultDelay;
            rule.cloudwatchTimestamp = yamlMetricRule.containsKey("set_timestamp") ? (Boolean)yamlMetricRule.get("set_timestamp") : defaultCloudwatchTimestamp;
            if (!yamlMetricRule.containsKey("aws_tag_select")) continue;
            Map yamlAwsTagSelect = (Map)yamlMetricRule.get("aws_tag_select");
            if (!yamlAwsTagSelect.containsKey("resource_type_selection") || !yamlAwsTagSelect.containsKey("resource_id_dimension")) {
                throw new IllegalArgumentException("Must provide resource_type_selection and resource_id_dimension");
            }
            rule.awsTagSelect = awsTagSelect = new AWSTagSelect();
            awsTagSelect.resourceTypeSelection = (String)yamlAwsTagSelect.get("resource_type_selection");
            awsTagSelect.resourceIdDimension = (String)yamlAwsTagSelect.get("resource_id_dimension");
            if (!yamlAwsTagSelect.containsKey("tag_selections")) continue;
            awsTagSelect.tagSelections = (Map)yamlAwsTagSelect.get("tag_selections");
        }
        this.loadConfig(rules, cloudWatchClient, taggingClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfig(ArrayList<MetricRule> rules, AmazonCloudWatch cloudWatchClient, AWSResourceGroupsTaggingAPI taggingClient) {
        ActiveConfig activeConfig = this.activeConfig;
        synchronized (activeConfig) {
            this.activeConfig.cloudWatchClient = cloudWatchClient;
            this.activeConfig.taggingClient = taggingClient;
            this.activeConfig.rules = rules;
        }
    }

    private AWSCredentialsProvider getRoleCredentialProvider(Map<String, Object> config) {
        STSAssumeRoleSessionCredentialsProvider credentialsProvider = new STSAssumeRoleSessionCredentialsProvider.Builder((String)config.get("role_arn"), "cloudwatch_exporter").build();
        return credentialsProvider;
    }

    private List<ResourceTagMapping> getResourceTagMappings(MetricRule rule, AWSResourceGroupsTaggingAPI taggingClient) {
        GetResourcesResult result;
        if (rule.awsTagSelect == null) {
            return Collections.emptyList();
        }
        ArrayList<TagFilter> tagFilters = new ArrayList<TagFilter>();
        if (rule.awsTagSelect.tagSelections != null) {
            for (Map.Entry<String, List<String>> entry : rule.awsTagSelect.tagSelections.entrySet()) {
                tagFilters.add(new TagFilter().withKey(entry.getKey()).withValues((Collection)entry.getValue()));
            }
        }
        ArrayList<ResourceTagMapping> resourceTagMappings = new ArrayList<ResourceTagMapping>();
        GetResourcesRequest request = new GetResourcesRequest().withTagFilters(tagFilters).withResourceTypeFilters(new String[]{rule.awsTagSelect.resourceTypeSelection});
        String paginationToken = "";
        do {
            request.setPaginationToken(paginationToken);
            result = taggingClient.getResources(request);
            ((Counter.Child)taggingApiRequests.labels(new String[]{"getResources", rule.awsTagSelect.resourceTypeSelection})).inc();
            resourceTagMappings.addAll(result.getResourceTagMappingList());
        } while ((paginationToken = result.getPaginationToken()) != null && paginationToken != "");
        return resourceTagMappings;
    }

    private List<String> extractResourceIds(List<ResourceTagMapping> resourceTagMappings) {
        ArrayList<String> resourceIds = new ArrayList<String>();
        for (ResourceTagMapping resourceTagMapping : resourceTagMappings) {
            resourceIds.add(this.extractResourceIdFromArn(resourceTagMapping.getResourceARN()));
        }
        return resourceIds;
    }

    private String extractResourceIdFromArn(String arn) {
        String[] arnArray = arn.split(":");
        String resourceId = arnArray[arnArray.length - 1];
        if (resourceId.contains("/")) {
            String[] resourceArray = resourceId.split("/", 2);
            resourceId = resourceArray[resourceArray.length - 1];
        }
        return resourceId;
    }

    private List<List<Dimension>> getDimensions(MetricRule rule, List<String> tagBasedResourceIds, AmazonCloudWatch cloudWatchClient) {
        if (rule.awsDimensions != null && rule.awsDimensionSelect != null && rule.awsDimensions.size() > 0 && rule.awsDimensions.size() == rule.awsDimensionSelect.size() && rule.awsDimensionSelect.keySet().containsAll(rule.awsDimensions) && rule.awsTagSelect == null) {
            return this.permuteDimensions(rule.awsDimensions, rule.awsDimensionSelect);
        }
        return this.listDimensions(rule, tagBasedResourceIds, cloudWatchClient);
    }

    private List<List<Dimension>> permuteDimensions(List<String> dimensions, Map<String, List<String>> dimensionValues) {
        ArrayList<List<Dimension>> result = new ArrayList<List<Dimension>>();
        if (dimensions.size() == 0) {
            result.add(new ArrayList());
        } else {
            ArrayList<String> dimensionsCopy = new ArrayList<String>(dimensions);
            String dimensionName = (String)dimensionsCopy.remove(dimensionsCopy.size() - 1);
            for (List<Dimension> permutation : this.permuteDimensions(dimensionsCopy, dimensionValues)) {
                for (String dimensionValue : dimensionValues.get(dimensionName)) {
                    Dimension dimension = new Dimension();
                    dimension.setValue(dimensionValue);
                    dimension.setName(dimensionName);
                    ArrayList<Dimension> permutationCopy = new ArrayList<Dimension>(permutation);
                    permutationCopy.add(dimension);
                    result.add(permutationCopy);
                }
            }
        }
        return result;
    }

    private List<List<Dimension>> listDimensions(MetricRule rule, List<String> tagBasedResourceIds, AmazonCloudWatch cloudWatchClient) {
        ListMetricsResult result;
        ArrayList<List<Dimension>> dimensions = new ArrayList<List<Dimension>>();
        if (rule.awsDimensions == null) {
            dimensions.add(new ArrayList());
            return dimensions;
        }
        ListMetricsRequest request = new ListMetricsRequest();
        request.setNamespace(rule.awsNamespace);
        request.setMetricName(rule.awsMetricName);
        if (rule.rangeSeconds < 10800) {
            request.setRecentlyActive("PT3H");
        }
        ArrayList<DimensionFilter> dimensionFilters = new ArrayList<DimensionFilter>();
        for (String dimension : rule.awsDimensions) {
            dimensionFilters.add(new DimensionFilter().withName(dimension));
        }
        request.setDimensions(dimensionFilters);
        String nextToken = null;
        do {
            request.setNextToken(nextToken);
            result = cloudWatchClient.listMetrics(request);
            ((Counter.Child)cloudwatchRequests.labels(new String[]{"listMetrics", rule.awsNamespace})).inc();
            for (Metric metric : result.getMetrics()) {
                if (metric.getDimensions().size() != dimensionFilters.size() || !this.useMetric(rule, tagBasedResourceIds, metric)) continue;
                dimensions.add(metric.getDimensions());
            }
        } while ((nextToken = result.getNextToken()) != null);
        return dimensions;
    }

    private boolean useMetric(MetricRule rule, List<String> tagBasedResourceIds, Metric metric) {
        if (rule.awsDimensionSelect != null && !this.metricsIsInAwsDimensionSelect(rule, metric)) {
            return false;
        }
        if (rule.awsDimensionSelectRegex != null && !this.metricIsInAwsDimensionSelectRegex(rule, metric)) {
            return false;
        }
        return rule.awsTagSelect == null || this.metricIsInAwsTagSelect(rule, tagBasedResourceIds, metric);
    }

    private boolean metricsIsInAwsDimensionSelect(MetricRule rule, Metric metric) {
        Set<String> dimensionSelectKeys = rule.awsDimensionSelect.keySet();
        for (Dimension dimension : metric.getDimensions()) {
            List<String> allowedDimensionValues;
            String dimensionName = dimension.getName();
            String dimensionValue = dimension.getValue();
            if (!dimensionSelectKeys.contains(dimensionName) || (allowedDimensionValues = rule.awsDimensionSelect.get(dimensionName)).contains(dimensionValue)) continue;
            return false;
        }
        return true;
    }

    private boolean metricIsInAwsDimensionSelectRegex(MetricRule rule, Metric metric) {
        Set<String> dimensionSelectRegexKeys = rule.awsDimensionSelectRegex.keySet();
        for (Dimension dimension : metric.getDimensions()) {
            List<String> allowedDimensionValues;
            String dimensionName = dimension.getName();
            String dimensionValue = dimension.getValue();
            if (!dimensionSelectRegexKeys.contains(dimensionName) || CloudWatchCollector.regexListMatch(allowedDimensionValues = rule.awsDimensionSelectRegex.get(dimensionName), dimensionValue)) continue;
            return false;
        }
        return true;
    }

    protected static boolean regexListMatch(List<String> regexList, String input) {
        for (String regex : regexList) {
            if (!Pattern.matches(regex, input)) continue;
            return true;
        }
        return false;
    }

    private boolean metricIsInAwsTagSelect(MetricRule rule, List<String> tagBasedResourceIds, Metric metric) {
        if (rule.awsTagSelect.tagSelections == null) {
            return true;
        }
        for (Dimension dimension : metric.getDimensions()) {
            String dimensionName = dimension.getName();
            String dimensionValue = dimension.getValue();
            if (!rule.awsTagSelect.resourceIdDimension.equals(dimensionName) || tagBasedResourceIds.contains(dimensionValue)) continue;
            return false;
        }
        return true;
    }

    private Datapoint getNewestDatapoint(List<Datapoint> datapoints) {
        Datapoint newest = null;
        for (Datapoint d : datapoints) {
            if (newest != null && !newest.getTimestamp().before(d.getTimestamp())) continue;
            newest = d;
        }
        return newest;
    }

    private String toSnakeCase(String str) {
        return str.replaceAll("([a-z0-9])([A-Z])", "$1_$2").toLowerCase();
    }

    private String safeName(String s) {
        return s.replaceAll("[^a-zA-Z0-9:_]", "_").replaceAll("__+", "_");
    }

    private String safeLabelName(String s) {
        return s.replaceAll("[^a-zA-Z0-9_]", "_").replaceAll("__+", "_");
    }

    private String help(MetricRule rule, String unit, String statistic) {
        if (rule.help != null) {
            return rule.help;
        }
        return "CloudWatch metric " + rule.awsNamespace + " " + rule.awsMetricName + " Dimensions: " + rule.awsDimensions + " Statistic: " + statistic + " Unit: " + unit;
    }

    private void scrape(List<Collector.MetricFamilySamples> mfs) throws CloneNotSupportedException {
        ActiveConfig config = (ActiveConfig)this.activeConfig.clone();
        HashSet<String> publishedResourceInfo = new HashSet<String>();
        long start = System.currentTimeMillis();
        ArrayList<Collector.MetricFamilySamples.Sample> infoSamples = new ArrayList<Collector.MetricFamilySamples.Sample>();
        for (MetricRule rule : config.rules) {
            Date startDate = new Date(start - (long)(1000 * rule.delaySeconds));
            Date endDate = new Date(start - (long)(1000 * (rule.delaySeconds + rule.rangeSeconds)));
            GetMetricStatisticsRequest request = new GetMetricStatisticsRequest();
            request.setNamespace(rule.awsNamespace);
            request.setMetricName(rule.awsMetricName);
            request.setStatistics(rule.awsStatistics);
            request.setExtendedStatistics(rule.awsExtendedStatistics);
            request.setEndTime(startDate);
            request.setStartTime(endDate);
            request.setPeriod(Integer.valueOf(rule.periodSeconds));
            String baseName = this.safeName(rule.awsNamespace.toLowerCase() + "_" + this.toSnakeCase(rule.awsMetricName));
            String jobName = this.safeName(rule.awsNamespace.toLowerCase());
            ArrayList<Collector.MetricFamilySamples.Sample> sumSamples = new ArrayList<Collector.MetricFamilySamples.Sample>();
            ArrayList<Collector.MetricFamilySamples.Sample> sampleCountSamples = new ArrayList<Collector.MetricFamilySamples.Sample>();
            ArrayList<Collector.MetricFamilySamples.Sample> minimumSamples = new ArrayList<Collector.MetricFamilySamples.Sample>();
            ArrayList<Collector.MetricFamilySamples.Sample> maximumSamples = new ArrayList<Collector.MetricFamilySamples.Sample>();
            ArrayList<Collector.MetricFamilySamples.Sample> averageSamples = new ArrayList<Collector.MetricFamilySamples.Sample>();
            HashMap extendedSamples = new HashMap();
            String unit = null;
            if (rule.awsNamespace.equals("AWS/DynamoDB") && rule.awsDimensions != null && rule.awsDimensions.contains("GlobalSecondaryIndexName") && brokenDynamoMetrics.contains(rule.awsMetricName)) {
                baseName = baseName + "_index";
            }
            List<ResourceTagMapping> resourceTagMappings = this.getResourceTagMappings(rule, config.taggingClient);
            List<String> tagBasedResourceIds = this.extractResourceIds(resourceTagMappings);
            for (List<Dimension> list : this.getDimensions(rule, tagBasedResourceIds, config.cloudWatchClient)) {
                request.setDimensions(list);
                GetMetricStatisticsResult result = config.cloudWatchClient.getMetricStatistics(request);
                ((Counter.Child)cloudwatchRequests.labels(new String[]{"getMetricStatistics", rule.awsNamespace})).inc();
                Datapoint dp = this.getNewestDatapoint(result.getDatapoints());
                if (dp == null) continue;
                unit = dp.getUnit();
                ArrayList<String> labelNames = new ArrayList<String>();
                ArrayList<String> labelValues = new ArrayList<String>();
                labelNames.add("job");
                labelValues.add(jobName);
                labelNames.add("instance");
                labelValues.add("");
                for (Dimension d : list) {
                    labelNames.add(this.safeLabelName(this.toSnakeCase(d.getName())));
                    labelValues.add(d.getValue());
                }
                Long timestamp = null;
                if (rule.cloudwatchTimestamp) {
                    timestamp = dp.getTimestamp().getTime();
                }
                if (dp.getSum() != null) {
                    sumSamples.add(new Collector.MetricFamilySamples.Sample(baseName + "_sum", labelNames, labelValues, dp.getSum().doubleValue(), timestamp));
                }
                if (dp.getSampleCount() != null) {
                    sampleCountSamples.add(new Collector.MetricFamilySamples.Sample(baseName + "_sample_count", labelNames, labelValues, dp.getSampleCount().doubleValue(), timestamp));
                }
                if (dp.getMinimum() != null) {
                    minimumSamples.add(new Collector.MetricFamilySamples.Sample(baseName + "_minimum", labelNames, labelValues, dp.getMinimum().doubleValue(), timestamp));
                }
                if (dp.getMaximum() != null) {
                    maximumSamples.add(new Collector.MetricFamilySamples.Sample(baseName + "_maximum", labelNames, labelValues, dp.getMaximum().doubleValue(), timestamp));
                }
                if (dp.getAverage() != null) {
                    averageSamples.add(new Collector.MetricFamilySamples.Sample(baseName + "_average", labelNames, labelValues, dp.getAverage().doubleValue(), timestamp));
                }
                if (dp.getExtendedStatistics() == null) continue;
                for (Map.Entry entry : dp.getExtendedStatistics().entrySet()) {
                    ArrayList<Collector.MetricFamilySamples.Sample> samples = (ArrayList<Collector.MetricFamilySamples.Sample>)extendedSamples.get(entry.getKey());
                    if (samples == null) {
                        samples = new ArrayList<Collector.MetricFamilySamples.Sample>();
                        extendedSamples.put(entry.getKey(), samples);
                    }
                    samples.add(new Collector.MetricFamilySamples.Sample(baseName + "_" + this.safeName(this.toSnakeCase((String)entry.getKey())), labelNames, labelValues, ((Double)entry.getValue()).doubleValue(), timestamp));
                }
            }
            if (!sumSamples.isEmpty()) {
                mfs.add(new Collector.MetricFamilySamples(baseName + "_sum", Collector.Type.GAUGE, this.help(rule, unit, "Sum"), sumSamples));
            }
            if (!sampleCountSamples.isEmpty()) {
                mfs.add(new Collector.MetricFamilySamples(baseName + "_sample_count", Collector.Type.GAUGE, this.help(rule, unit, "SampleCount"), sampleCountSamples));
            }
            if (!minimumSamples.isEmpty()) {
                mfs.add(new Collector.MetricFamilySamples(baseName + "_minimum", Collector.Type.GAUGE, this.help(rule, unit, "Minimum"), minimumSamples));
            }
            if (!maximumSamples.isEmpty()) {
                mfs.add(new Collector.MetricFamilySamples(baseName + "_maximum", Collector.Type.GAUGE, this.help(rule, unit, "Maximum"), maximumSamples));
            }
            if (!averageSamples.isEmpty()) {
                mfs.add(new Collector.MetricFamilySamples(baseName + "_average", Collector.Type.GAUGE, this.help(rule, unit, "Average"), averageSamples));
            }
            for (Map.Entry entry : extendedSamples.entrySet()) {
                mfs.add(new Collector.MetricFamilySamples(baseName + "_" + this.safeName(this.toSnakeCase((String)entry.getKey())), Collector.Type.GAUGE, this.help(rule, unit, (String)entry.getKey()), (List)entry.getValue()));
            }
            for (ResourceTagMapping resourceTagMapping : resourceTagMappings) {
                if (publishedResourceInfo.contains(resourceTagMapping.getResourceARN())) continue;
                ArrayList<String> labelNames = new ArrayList<String>();
                ArrayList<String> labelValues = new ArrayList<String>();
                labelNames.add("job");
                labelValues.add(jobName);
                labelNames.add("instance");
                labelValues.add("");
                labelNames.add("arn");
                labelValues.add(resourceTagMapping.getResourceARN());
                labelNames.add(this.safeLabelName(this.toSnakeCase(rule.awsTagSelect.resourceIdDimension)));
                labelValues.add(this.extractResourceIdFromArn(resourceTagMapping.getResourceARN()));
                for (Tag tag : resourceTagMapping.getTags()) {
                    labelNames.add("tag_" + this.safeLabelName(tag.getKey()));
                    labelValues.add(tag.getValue());
                }
                infoSamples.add(new Collector.MetricFamilySamples.Sample("aws_resource_info", labelNames, labelValues, 1.0));
                publishedResourceInfo.add(resourceTagMapping.getResourceARN());
            }
        }
        mfs.add(new Collector.MetricFamilySamples("aws_resource_info", Collector.Type.GAUGE, "AWS information available for resource", infoSamples));
    }

    public List<Collector.MetricFamilySamples> collect() {
        long start = System.nanoTime();
        double error = 0.0;
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        try {
            this.scrape(mfs);
        }
        catch (Exception e) {
            error = 1.0;
            LOGGER.log(Level.WARNING, "CloudWatch scrape failed", e);
        }
        ArrayList<Collector.MetricFamilySamples.Sample> samples = new ArrayList<Collector.MetricFamilySamples.Sample>();
        samples.add(new Collector.MetricFamilySamples.Sample("cloudwatch_exporter_scrape_duration_seconds", new ArrayList(), new ArrayList(), (double)(System.nanoTime() - start) / 1.0E9));
        mfs.add(new Collector.MetricFamilySamples("cloudwatch_exporter_scrape_duration_seconds", Collector.Type.GAUGE, "Time this CloudWatch scrape took, in seconds.", samples));
        samples = new ArrayList();
        samples.add(new Collector.MetricFamilySamples.Sample("cloudwatch_exporter_scrape_error", new ArrayList(), new ArrayList(), error));
        mfs.add(new Collector.MetricFamilySamples("cloudwatch_exporter_scrape_error", Collector.Type.GAUGE, "Non-zero if this scrape failed.", samples));
        return mfs;
    }

    public static void main(String[] args) throws Exception {
        String region = "eu-west-1";
        if (args.length > 0) {
            region = args[0];
        }
        CloudWatchCollector jc = new CloudWatchCollector(("{`region`: `" + region + "`,`metrics`: [{`aws_namespace`: `AWS/ELB`, `aws_metric_name`: `RequestCount`, `aws_dimensions`: [`AvailabilityZone`, `LoadBalancerName`]}] ,}").replace('`', '\"'));
        for (Collector.MetricFamilySamples mfs : jc.collect()) {
            System.out.println(mfs);
        }
    }

    static class AWSTagSelect {
        String resourceTypeSelection;
        String resourceIdDimension;
        Map<String, List<String>> tagSelections;

        AWSTagSelect() {
        }
    }

    static class MetricRule {
        String awsNamespace;
        String awsMetricName;
        int periodSeconds;
        int rangeSeconds;
        int delaySeconds;
        List<String> awsStatistics;
        List<String> awsExtendedStatistics;
        List<String> awsDimensions;
        Map<String, List<String>> awsDimensionSelect;
        Map<String, List<String>> awsDimensionSelectRegex;
        AWSTagSelect awsTagSelect;
        String help;
        boolean cloudwatchTimestamp;

        MetricRule() {
        }
    }

    static class ActiveConfig
    implements Cloneable {
        ArrayList<MetricRule> rules;
        AmazonCloudWatch cloudWatchClient;
        AWSResourceGroupsTaggingAPI taggingClient;

        ActiveConfig() {
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }
}

