/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.cloudwatch;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchClient;
import com.amazonaws.services.cloudwatch.model.Datapoint;
import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.services.cloudwatch.model.DimensionFilter;
import com.amazonaws.services.cloudwatch.model.GetMetricStatisticsRequest;
import com.amazonaws.services.cloudwatch.model.GetMetricStatisticsResult;
import com.amazonaws.services.cloudwatch.model.ListMetricsRequest;
import com.amazonaws.services.cloudwatch.model.ListMetricsResult;
import com.amazonaws.services.cloudwatch.model.Metric;
import io.prometheus.client.Collector;
import io.prometheus.client.Counter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.Yaml;

public class CloudWatchCollector
extends Collector {
    private static final Logger LOGGER = Logger.getLogger(CloudWatchCollector.class.getName());
    AmazonCloudWatchClient client;
    Region region;
    private static final Counter cloudwatchRequests = (Counter)((Counter.Builder)((Counter.Builder)Counter.build().name("cloudwatch_requests_total")).help("API requests made to CloudWatch")).register();
    private static final List<String> brokenDynamoMetrics = Arrays.asList("ConsumedReadCapacityUnits", "ConsumedWriteCapacityUnits", "ProvisionedReadCapacityUnits", "ProvisionedWriteCapacityUnits", "ReadThrottleEvents", "WriteThrottleEvents");
    ArrayList<MetricRule> rules = new ArrayList();

    public CloudWatchCollector(Reader in) throws IOException {
        this((Map)new Yaml().load(in), null);
    }

    public CloudWatchCollector(String yamlConfig) {
        this((Map)new Yaml().load(yamlConfig), null);
    }

    protected CloudWatchCollector(String jsonConfig, AmazonCloudWatchClient client) {
        this((Map)new Yaml().load(jsonConfig), client);
    }

    private CloudWatchCollector(Map<String, Object> config, AmazonCloudWatchClient client) {
        if (config == null) {
            config = new HashMap<String, Object>();
        }
        if (!config.containsKey("region")) {
            throw new IllegalArgumentException("Must provide region");
        }
        this.region = RegionUtils.getRegion((String)((String)config.get("region")));
        int defaultPeriod = 60;
        if (config.containsKey("period_seconds")) {
            defaultPeriod = ((Number)config.get("period_seconds")).intValue();
        }
        int defaultRange = 600;
        if (config.containsKey("range_seconds")) {
            defaultRange = ((Number)config.get("range_seconds")).intValue();
        }
        int defaultDelay = 600;
        if (config.containsKey("delay_seconds")) {
            defaultDelay = ((Number)config.get("delay_seconds")).intValue();
        }
        if (client == null) {
            if (config.containsKey("role_arn")) {
                STSAssumeRoleSessionCredentialsProvider credentialsProvider = new STSAssumeRoleSessionCredentialsProvider((String)config.get("role_arn"), "cloudwatch_exporter");
                this.client = new AmazonCloudWatchClient((AWSCredentialsProvider)credentialsProvider);
            } else {
                this.client = new AmazonCloudWatchClient();
            }
            this.client.setEndpoint(this.getMonitoringEndpoint());
        } else {
            this.client = client;
        }
        if (!config.containsKey("metrics")) {
            throw new IllegalArgumentException("Must provide metrics");
        }
        for (Object ruleObject : (List)config.get("metrics")) {
            Map yamlMetricRule = (Map)ruleObject;
            MetricRule rule = new MetricRule();
            this.rules.add(rule);
            if (!yamlMetricRule.containsKey("aws_namespace") || !yamlMetricRule.containsKey("aws_metric_name")) {
                throw new IllegalArgumentException("Must provide aws_namespace and aws_metric_name");
            }
            rule.awsNamespace = (String)yamlMetricRule.get("aws_namespace");
            rule.awsMetricName = (String)yamlMetricRule.get("aws_metric_name");
            if (yamlMetricRule.containsKey("help")) {
                rule.help = (String)yamlMetricRule.get("help");
            }
            if (yamlMetricRule.containsKey("aws_dimensions")) {
                rule.awsDimensions = (List)yamlMetricRule.get("aws_dimensions");
            }
            if (yamlMetricRule.containsKey("aws_dimension_select") && yamlMetricRule.containsKey("aws_dimension_select_regex")) {
                throw new IllegalArgumentException("Must not provide aws_dimension_select and aws_dimension_select_regex at the same time");
            }
            if (yamlMetricRule.containsKey("aws_dimension_select")) {
                rule.awsDimensionSelect = (Map)yamlMetricRule.get("aws_dimension_select");
            }
            if (yamlMetricRule.containsKey("aws_dimension_select_regex")) {
                rule.awsDimensionSelectRegex = (Map)yamlMetricRule.get("aws_dimension_select_regex");
            }
            if (yamlMetricRule.containsKey("aws_statistics")) {
                rule.awsStatistics = (List)yamlMetricRule.get("aws_statistics");
            } else if (!yamlMetricRule.containsKey("aws_extended_statistics")) {
                rule.awsStatistics = new ArrayList<String>(Arrays.asList("Sum", "SampleCount", "Minimum", "Maximum", "Average"));
            }
            if (yamlMetricRule.containsKey("aws_extended_statistics")) {
                rule.awsExtendedStatistics = (List)yamlMetricRule.get("aws_extended_statistics");
            }
            rule.periodSeconds = yamlMetricRule.containsKey("period_seconds") ? ((Number)yamlMetricRule.get("period_seconds")).intValue() : defaultPeriod;
            rule.rangeSeconds = yamlMetricRule.containsKey("range_seconds") ? ((Number)yamlMetricRule.get("range_seconds")).intValue() : defaultRange;
            if (yamlMetricRule.containsKey("delay_seconds")) {
                rule.delaySeconds = ((Number)yamlMetricRule.get("delay_seconds")).intValue();
                continue;
            }
            rule.delaySeconds = defaultDelay;
        }
    }

    public String getMonitoringEndpoint() {
        return "https://" + this.region.getServiceEndpoint("monitoring");
    }

    private List<List<Dimension>> getDimensions(MetricRule rule) {
        ListMetricsResult result;
        ArrayList<List<Dimension>> dimensions = new ArrayList<List<Dimension>>();
        if (rule.awsDimensions == null) {
            dimensions.add(new ArrayList());
            return dimensions;
        }
        ListMetricsRequest request = new ListMetricsRequest();
        request.setNamespace(rule.awsNamespace);
        request.setMetricName(rule.awsMetricName);
        ArrayList<DimensionFilter> dimensionFilters = new ArrayList<DimensionFilter>();
        for (String dimension : rule.awsDimensions) {
            dimensionFilters.add(new DimensionFilter().withName(dimension));
        }
        request.setDimensions(dimensionFilters);
        String nextToken = null;
        do {
            request.setNextToken(nextToken);
            result = this.client.listMetrics(request);
            cloudwatchRequests.inc();
            for (Metric metric : result.getMetrics()) {
                if (metric.getDimensions().size() != dimensionFilters.size() || !this.useMetric(rule, metric)) continue;
                dimensions.add(metric.getDimensions());
            }
        } while ((nextToken = result.getNextToken()) != null);
        return dimensions;
    }

    private boolean useMetric(MetricRule rule, Metric metric) {
        if (rule.awsDimensionSelect == null && rule.awsDimensionSelectRegex == null) {
            return true;
        }
        if (rule.awsDimensionSelect != null && this.metricsIsInAwsDimensionSelect(rule, metric)) {
            return true;
        }
        return rule.awsDimensionSelectRegex != null && this.metricIsInAwsDimensionSelectRegex(rule, metric);
    }

    private boolean metricsIsInAwsDimensionSelect(MetricRule rule, Metric metric) {
        Set<String> dimensionSelectKeys = rule.awsDimensionSelect.keySet();
        for (Dimension dimension : metric.getDimensions()) {
            List<String> allowedDimensionValues;
            String dimensionName = dimension.getName();
            String dimensionValue = dimension.getValue();
            if (!dimensionSelectKeys.contains(dimensionName) || (allowedDimensionValues = rule.awsDimensionSelect.get(dimensionName)).contains(dimensionValue)) continue;
            return false;
        }
        return true;
    }

    private boolean metricIsInAwsDimensionSelectRegex(MetricRule rule, Metric metric) {
        Set<String> dimensionSelectRegexKeys = rule.awsDimensionSelectRegex.keySet();
        for (Dimension dimension : metric.getDimensions()) {
            List<String> allowedDimensionValues;
            String dimensionName = dimension.getName();
            String dimensionValue = dimension.getValue();
            if (!dimensionSelectRegexKeys.contains(dimensionName) || CloudWatchCollector.regexListMatch(allowedDimensionValues = rule.awsDimensionSelectRegex.get(dimensionName), dimensionValue)) continue;
            return false;
        }
        return true;
    }

    protected static boolean regexListMatch(List<String> regexList, String input) {
        for (String regex : regexList) {
            if (!Pattern.matches(regex, input)) continue;
            return true;
        }
        return false;
    }

    private Datapoint getNewestDatapoint(List<Datapoint> datapoints) {
        Datapoint newest = null;
        for (Datapoint d : datapoints) {
            if (newest != null && !newest.getTimestamp().before(d.getTimestamp())) continue;
            newest = d;
        }
        return newest;
    }

    private String toSnakeCase(String str) {
        return str.replaceAll("([a-z0-9])([A-Z])", "$1_$2").toLowerCase();
    }

    private String safeName(String s) {
        return s.replaceAll("[^a-zA-Z0-9:_]", "_").replaceAll("__+", "_");
    }

    private String help(MetricRule rule, String unit, String statistic) {
        if (rule.help != null) {
            return rule.help;
        }
        return "CloudWatch metric " + rule.awsNamespace + " " + rule.awsMetricName + " Dimensions: " + rule.awsDimensions + " Statistic: " + statistic + " Unit: " + unit;
    }

    private void scrape(List<Collector.MetricFamilySamples> mfs) {
        long start = System.currentTimeMillis();
        for (MetricRule rule : this.rules) {
            Date startDate = new Date(start - (long)(1000 * rule.delaySeconds));
            Date endDate = new Date(start - (long)(1000 * (rule.delaySeconds + rule.rangeSeconds)));
            GetMetricStatisticsRequest request = new GetMetricStatisticsRequest();
            request.setNamespace(rule.awsNamespace);
            request.setMetricName(rule.awsMetricName);
            request.setStatistics(rule.awsStatistics);
            request.setExtendedStatistics(rule.awsExtendedStatistics);
            request.setEndTime(startDate);
            request.setStartTime(endDate);
            request.setPeriod(Integer.valueOf(rule.periodSeconds));
            String baseName = this.safeName(rule.awsNamespace.toLowerCase() + "_" + this.toSnakeCase(rule.awsMetricName));
            String jobName = this.safeName(rule.awsNamespace.toLowerCase());
            ArrayList<Collector.MetricFamilySamples.Sample> sumSamples = new ArrayList<Collector.MetricFamilySamples.Sample>();
            ArrayList<Collector.MetricFamilySamples.Sample> sampleCountSamples = new ArrayList<Collector.MetricFamilySamples.Sample>();
            ArrayList<Collector.MetricFamilySamples.Sample> minimumSamples = new ArrayList<Collector.MetricFamilySamples.Sample>();
            ArrayList<Collector.MetricFamilySamples.Sample> maximumSamples = new ArrayList<Collector.MetricFamilySamples.Sample>();
            ArrayList<Collector.MetricFamilySamples.Sample> averageSamples = new ArrayList<Collector.MetricFamilySamples.Sample>();
            HashMap extendedSamples = new HashMap();
            String unit = null;
            if (rule.awsNamespace.equals("AWS/DynamoDB") && rule.awsDimensions.contains("GlobalSecondaryIndexName") && brokenDynamoMetrics.contains(rule.awsMetricName)) {
                baseName = baseName + "_index";
            }
            for (List<Dimension> list : this.getDimensions(rule)) {
                request.setDimensions(list);
                GetMetricStatisticsResult result = this.client.getMetricStatistics(request);
                cloudwatchRequests.inc();
                Datapoint dp = this.getNewestDatapoint(result.getDatapoints());
                if (dp == null) continue;
                unit = dp.getUnit();
                ArrayList<String> labelNames = new ArrayList<String>();
                ArrayList<String> labelValues = new ArrayList<String>();
                labelNames.add("job");
                labelValues.add(jobName);
                labelNames.add("instance");
                labelValues.add("");
                for (Dimension dimension : list) {
                    labelNames.add(this.safeName(this.toSnakeCase(dimension.getName())));
                    labelValues.add(dimension.getValue());
                }
                if (dp.getSum() != null) {
                    sumSamples.add(new Collector.MetricFamilySamples.Sample(baseName + "_sum", labelNames, labelValues, dp.getSum().doubleValue()));
                }
                if (dp.getSampleCount() != null) {
                    sampleCountSamples.add(new Collector.MetricFamilySamples.Sample(baseName + "_sample_count", labelNames, labelValues, dp.getSampleCount().doubleValue()));
                }
                if (dp.getMinimum() != null) {
                    minimumSamples.add(new Collector.MetricFamilySamples.Sample(baseName + "_minimum", labelNames, labelValues, dp.getMinimum().doubleValue()));
                }
                if (dp.getMaximum() != null) {
                    maximumSamples.add(new Collector.MetricFamilySamples.Sample(baseName + "_maximum", labelNames, labelValues, dp.getMaximum().doubleValue()));
                }
                if (dp.getAverage() != null) {
                    averageSamples.add(new Collector.MetricFamilySamples.Sample(baseName + "_average", labelNames, labelValues, dp.getAverage().doubleValue()));
                }
                if (dp.getExtendedStatistics() == null) continue;
                for (Map.Entry entry : dp.getExtendedStatistics().entrySet()) {
                    ArrayList<Collector.MetricFamilySamples.Sample> samples = (ArrayList<Collector.MetricFamilySamples.Sample>)extendedSamples.get(entry.getKey());
                    if (samples == null) {
                        samples = new ArrayList<Collector.MetricFamilySamples.Sample>();
                        extendedSamples.put(entry.getKey(), samples);
                    }
                    samples.add(new Collector.MetricFamilySamples.Sample(baseName + "_" + this.safeName(this.toSnakeCase((String)entry.getKey())), labelNames, labelValues, ((Double)entry.getValue()).doubleValue()));
                }
            }
            if (!sumSamples.isEmpty()) {
                mfs.add(new Collector.MetricFamilySamples(baseName + "_sum", Collector.Type.GAUGE, this.help(rule, unit, "Sum"), sumSamples));
            }
            if (!sampleCountSamples.isEmpty()) {
                mfs.add(new Collector.MetricFamilySamples(baseName + "_sample_count", Collector.Type.GAUGE, this.help(rule, unit, "SampleCount"), sampleCountSamples));
            }
            if (!minimumSamples.isEmpty()) {
                mfs.add(new Collector.MetricFamilySamples(baseName + "_minimum", Collector.Type.GAUGE, this.help(rule, unit, "Minimum"), minimumSamples));
            }
            if (!maximumSamples.isEmpty()) {
                mfs.add(new Collector.MetricFamilySamples(baseName + "_maximum", Collector.Type.GAUGE, this.help(rule, unit, "Maximum"), maximumSamples));
            }
            if (!averageSamples.isEmpty()) {
                mfs.add(new Collector.MetricFamilySamples(baseName + "_average", Collector.Type.GAUGE, this.help(rule, unit, "Average"), averageSamples));
            }
            for (Map.Entry entry : extendedSamples.entrySet()) {
                mfs.add(new Collector.MetricFamilySamples(baseName + "_" + this.safeName(this.toSnakeCase((String)entry.getKey())), Collector.Type.GAUGE, this.help(rule, unit, (String)entry.getKey()), (List)entry.getValue()));
            }
        }
    }

    public List<Collector.MetricFamilySamples> collect() {
        long start = System.nanoTime();
        double error = 0.0;
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        try {
            this.scrape(mfs);
        }
        catch (Exception e) {
            error = 1.0;
            LOGGER.log(Level.WARNING, "CloudWatch scrape failed", e);
        }
        ArrayList<Collector.MetricFamilySamples.Sample> samples = new ArrayList<Collector.MetricFamilySamples.Sample>();
        samples.add(new Collector.MetricFamilySamples.Sample("cloudwatch_exporter_scrape_duration_seconds", new ArrayList(), new ArrayList(), (double)(System.nanoTime() - start) / 1.0E9));
        mfs.add(new Collector.MetricFamilySamples("cloudwatch_exporter_scrape_duration_seconds", Collector.Type.GAUGE, "Time this CloudWatch scrape took, in seconds.", samples));
        samples = new ArrayList();
        samples.add(new Collector.MetricFamilySamples.Sample("cloudwatch_exporter_scrape_error", new ArrayList(), new ArrayList(), error));
        mfs.add(new Collector.MetricFamilySamples("cloudwatch_exporter_scrape_error", Collector.Type.GAUGE, "Non-zero if this scrape failed.", samples));
        return mfs;
    }

    public static void main(String[] args) throws Exception {
        String region = "eu-west-1";
        if (args.length > 0) {
            region = args[0];
        }
        CloudWatchCollector jc = new CloudWatchCollector(("{`region`: `" + region + "`,`metrics`: [{`aws_namespace`: `AWS/ELB`, `aws_metric_name`: `RequestCount`, `aws_dimensions`: [`AvailabilityZone`, `LoadBalancerName`]}] ,}").replace('`', '\"'));
        for (Collector.MetricFamilySamples mfs : jc.collect()) {
            System.out.println(mfs);
        }
    }

    static class MetricRule {
        String awsNamespace;
        String awsMetricName;
        int periodSeconds;
        int rangeSeconds;
        int delaySeconds;
        List<String> awsStatistics;
        List<String> awsExtendedStatistics;
        List<String> awsDimensions;
        Map<String, List<String>> awsDimensionSelect;
        Map<String, List<String>> awsDimensionSelectRegex;
        String help;

        MetricRule() {
        }
    }
}

