/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client.utility.jvmstat;

import io.prometheus.client.Prometheus;
import io.prometheus.client.metrics.Gauge;
import java.lang.management.ManagementFactory;
import java.net.URISyntaxException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import java.util.regex.PatternSyntaxException;
import javax.annotation.concurrent.GuardedBy;
import sun.jvmstat.monitor.HostIdentifier;
import sun.jvmstat.monitor.Monitor;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.MonitoredHost;
import sun.jvmstat.monitor.MonitoredVm;
import sun.jvmstat.monitor.VmIdentifier;

public class JvmstatMonitor
implements Prometheus.ExpositionHook {
    private static final int REFRESH_INTERVAL = 5;
    private static final Gauge.Builder gaugePrototype = Gauge.newBuilder().namespace("jvmstat");
    private static final Logger log = Logger.getLogger(JvmstatMonitor.class.getName());
    private final MonitoredVm bridge;
    private final MonitorVisitor clsInstrumentation = new ClassLoaderInstrumentation();
    private final MonitorVisitor nccInstrumentation = new NativeCodeCompilerInstrumentation();
    private final MonitorVisitor gcInstrumentation = new GarbageCollectionInstrumentation();
    private final MonitorVisitor mmInstrumentation = new ManagedMemoryInstrumentation();
    private final AtomicInteger refreshes = new AtomicInteger(0);
    private final ConcurrentHashMap<String, Monitor> monitors = new ConcurrentHashMap(400);

    public JvmstatMonitor() throws AttachmentError {
        this(JvmstatMonitor.getLocalVM());
    }

    public JvmstatMonitor(MonitoredVm b) {
        this.bridge = b;
    }

    private void refreshMetrics() {
        List<Monitor> monitors;
        try {
            monitors = this.bridge.findByPattern(".*");
        }
        catch (MonitorException ex) {
            log.warning(String.format("could not extract telemetry: %s", ex));
            return;
        }
        catch (PatternSyntaxException ex) {
            log.warning(String.format("could not extract telemetry: %s", ex));
            return;
        }
        if (monitors == null) {
            return;
        }
        for (Monitor monitor : monitors) {
            this.monitors.putIfAbsent(monitor.getName(), monitor);
        }
    }

    public void run() {
        if (this.refreshes.getAndIncrement() % 5 == 0) {
            this.refreshMetrics();
        }
        for (String monitorName : this.monitors.keySet()) {
            Monitor monitor;
            if (!this.clsInstrumentation.visit(monitorName, monitor = this.monitors.get(monitorName)) && !this.nccInstrumentation.visit(monitorName, monitor) && !this.gcInstrumentation.visit(monitorName, monitor) && !this.mmInstrumentation.visit(monitorName, monitor)) continue;
        }
    }

    private static MonitoredVm getLocalVM() throws AttachmentError {
        int pid;
        String name = ManagementFactory.getRuntimeMXBean().getName();
        int pidOffset = name.indexOf(64);
        try {
            pid = Integer.valueOf(name.substring(0, pidOffset));
        }
        catch (IndexOutOfBoundsException ex) {
            throw new AttachmentError("illegal instance name", ex);
        }
        catch (NumberFormatException ex) {
            throw new AttachmentError("illegal instance name format", ex);
        }
        try {
            HostIdentifier hostId = new HostIdentifier((String)null);
            MonitoredHost host = MonitoredHost.getMonitoredHost(hostId);
            String localAddr = String.format("//%d?mode=r", pid);
            VmIdentifier id = new VmIdentifier(localAddr);
            return host.getMonitoredVm(id);
        }
        catch (URISyntaxException ex) {
            throw new AttachmentError("invalid target URI", ex);
        }
        catch (MonitorException ex) {
            throw new AttachmentError("could not resolve host", ex);
        }
    }

    private static Double decodeMetric(Monitor m) {
        Object value = m.getValue();
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            return (double)((Long)value);
        }
        try {
            return Double.valueOf(value.toString());
        }
        catch (NumberFormatException unused) {
            return null;
        }
    }

    static /* synthetic */ Gauge.Builder access$000() {
        return gaugePrototype;
    }

    static interface MonitorVisitor {
        public boolean visit(String var1, Monitor var2);
    }

    public static class ManagedMemoryInstrumentation
    implements MonitorVisitor {
        private static final Gauge.Builder gaugePrototype = JvmstatMonitor.access$000().subsystem("managed_memory");
        private final AtomicBoolean agetableCohortsOnce = new AtomicBoolean(false);
        private final AtomicBoolean agetableCountOnce = new AtomicBoolean(false);
        private final AtomicBoolean generationLimitOnce = new AtomicBoolean(false);
        private final AtomicBoolean generationUsageOnce = new AtomicBoolean(false);
        @GuardedBy(value="this")
        private Gauge agetableCohorts;
        @GuardedBy(value="this")
        private Gauge agetableCount;
        @GuardedBy(value="this")
        private Gauge generationLimit;
        @GuardedBy(value="this")
        private Gauge generationUsage;

        @Override
        public boolean visit(String name, Monitor monitor) {
            if ("sun.gc.generation.0.agetable.bytes.00".equals(name) || "sun.gc.generation.0.agetable.bytes.01".equals(name) || "sun.gc.generation.0.agetable.bytes.02".equals(name) || "sun.gc.generation.0.agetable.bytes.03".equals(name) || "sun.gc.generation.0.agetable.bytes.04".equals(name) || "sun.gc.generation.0.agetable.bytes.05".equals(name) || "sun.gc.generation.0.agetable.bytes.06".equals(name) || "sun.gc.generation.0.agetable.bytes.07".equals(name) || "sun.gc.generation.0.agetable.bytes.08".equals(name) || "sun.gc.generation.0.agetable.bytes.09".equals(name) || "sun.gc.generation.0.agetable.bytes.10".equals(name) || "sun.gc.generation.0.agetable.bytes.11".equals(name) || "sun.gc.generation.0.agetable.bytes.12".equals(name) || "sun.gc.generation.0.agetable.bytes.13".equals(name) || "sun.gc.generation.0.agetable.bytes.14".equals(name) || "sun.gc.generation.0.agetable.bytes.15".equals(name)) {
                return this.visitSurvivorSpaceAgetableCohorts(name, monitor);
            }
            if ("sun.gc.generation.0.agetable.size".equals(name)) {
                return this.visitSurvivorSpaceAgetableCount(monitor);
            }
            if ("sun.gc.generation.0.space.0.capacity".equals(name) || "sun.gc.generation.0.space.1.capacity".equals(name) || "sun.gc.generation.0.space.2.capacity".equals(name) || "sun.gc.generation.1.space.0.capacity".equals(name) || "sun.gc.generation.2.space.0.capacity".equals(name)) {
                return this.visitGenerationLimits(name, monitor);
            }
            if ("sun.gc.generation.0.space.0.used".equals(name) || "sun.gc.generation.0.space.1.used".equals(name) || "sun.gc.generation.0.space.2.used".equals(name) || "sun.gc.generation.1.space.0.used".equals(name) || "sun.gc.generation.2.space.0.used".equals(name)) {
                return this.visitGenerationUsage(name, monitor);
            }
            return false;
        }

        private boolean remarkGenerationLimit(String generation, Monitor monitor) {
            Double value = JvmstatMonitor.decodeMetric(monitor);
            if (value == null) {
                return false;
            }
            this.generationLimit.newPartial().labelPair("generation", generation).apply().set(value.doubleValue());
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean visitGenerationLimits(String name, Monitor monitor) {
            if (this.generationLimit == null) {
                ManagedMemoryInstrumentation managedMemoryInstrumentation = this;
                synchronized (managedMemoryInstrumentation) {
                    if (!this.generationLimitOnce.getAndSet(true)) {
                        this.generationLimit = gaugePrototype.name("generation_limit_bytes").labelNames(new String[]{"generation"}).documentation("The total allocation/reservation of each managed memory region or generation.").build();
                        this.notifyAll();
                    } else {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException ignored) {
                            // empty catch block
                        }
                    }
                }
            }
            if ("sun.gc.generation.0.space.0.capacity".equals(name)) {
                return this.remarkGenerationLimit("eden", monitor);
            }
            if ("sun.gc.generation.0.space.1.capacity".equals(name)) {
                return this.remarkGenerationLimit("survivor0", monitor);
            }
            if ("sun.gc.generation.0.space.2.capacity".equals(name)) {
                return this.remarkGenerationLimit("survivor1", monitor);
            }
            if ("sun.gc.generation.1.space.0.capacity".equals(name)) {
                return this.remarkGenerationLimit("old", monitor);
            }
            if ("sun.gc.generation.2.space.0.capacity".equals(name)) {
                return this.remarkGenerationLimit("permgen", monitor);
            }
            throw new UnknownMonitorError(monitor);
        }

        private boolean remarkGenerationUsage(String generation, Monitor monitor) {
            Double value = JvmstatMonitor.decodeMetric(monitor);
            if (value == null) {
                return false;
            }
            this.generationUsage.newPartial().labelPair("generation", generation).apply().set(value.doubleValue());
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean visitGenerationUsage(String name, Monitor monitor) {
            if (this.generationUsage == null) {
                ManagedMemoryInstrumentation managedMemoryInstrumentation = this;
                synchronized (managedMemoryInstrumentation) {
                    if (!this.generationUsageOnce.getAndSet(true)) {
                        this.generationUsage = gaugePrototype.name("generation_usage_bytes").labelNames(new String[]{"generation"}).documentation("The size used of each managed memory region or generation.").build();
                        this.notifyAll();
                    } else {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException ignored) {
                            // empty catch block
                        }
                    }
                }
            }
            if ("sun.gc.generation.0.space.0.used".equals(name)) {
                return this.remarkGenerationUsage("eden", monitor);
            }
            if ("sun.gc.generation.0.space.1.used".equals(name)) {
                return this.remarkGenerationUsage("survivor0", monitor);
            }
            if ("sun.gc.generation.0.space.2.used".equals(name)) {
                return this.remarkGenerationUsage("survivor1", monitor);
            }
            if ("sun.gc.generation.1.space.0.used".equals(name)) {
                return this.remarkGenerationUsage("old", monitor);
            }
            if ("sun.gc.generation.2.space.0.used".equals(name)) {
                return this.remarkGenerationUsage("permgen", monitor);
            }
            throw new UnknownMonitorError(monitor);
        }

        private boolean remarkAgetableCohortSize(String cohort, Monitor monitor) {
            Double value = JvmstatMonitor.decodeMetric(monitor);
            if (value == null) {
                return false;
            }
            this.agetableCohorts.newPartial().labelPair("cohort", cohort).apply().set(value.doubleValue());
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean visitSurvivorSpaceAgetableCohorts(String name, Monitor monitor) {
            if (this.agetableCohorts == null) {
                ManagedMemoryInstrumentation managedMemoryInstrumentation = this;
                synchronized (managedMemoryInstrumentation) {
                    if (!this.agetableCohortsOnce.getAndSet(true)) {
                        this.agetableCohorts = gaugePrototype.name("survivor_space_agetable_size_bytes").labelNames(new String[]{"cohort"}).documentation("A measure of the size of each survivor space agetable cohort.").build();
                        this.notifyAll();
                    } else {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException ignored) {
                            // empty catch block
                        }
                    }
                }
            }
            if ("sun.gc.generation.0.agetable.bytes.00".equals(name)) {
                return this.remarkAgetableCohortSize("00", monitor);
            }
            if ("sun.gc.generation.0.agetable.bytes.01".equals(name)) {
                return this.remarkAgetableCohortSize("01", monitor);
            }
            if ("sun.gc.generation.0.agetable.bytes.02".equals(name)) {
                return this.remarkAgetableCohortSize("02", monitor);
            }
            if ("sun.gc.generation.0.agetable.bytes.03".equals(name)) {
                return this.remarkAgetableCohortSize("03", monitor);
            }
            if ("sun.gc.generation.0.agetable.bytes.04".equals(name)) {
                return this.remarkAgetableCohortSize("04", monitor);
            }
            if ("sun.gc.generation.0.agetable.bytes.05".equals(name)) {
                return this.remarkAgetableCohortSize("05", monitor);
            }
            if ("sun.gc.generation.0.agetable.bytes.06".equals(name)) {
                return this.remarkAgetableCohortSize("06", monitor);
            }
            if ("sun.gc.generation.0.agetable.bytes.07".equals(name)) {
                return this.remarkAgetableCohortSize("07", monitor);
            }
            if ("sun.gc.generation.0.agetable.bytes.08".equals(name)) {
                return this.remarkAgetableCohortSize("08", monitor);
            }
            if ("sun.gc.generation.0.agetable.bytes.09".equals(name)) {
                return this.remarkAgetableCohortSize("09", monitor);
            }
            if ("sun.gc.generation.0.agetable.bytes.10".equals(name)) {
                return this.remarkAgetableCohortSize("10", monitor);
            }
            if ("sun.gc.generation.0.agetable.bytes.11".equals(name)) {
                return this.remarkAgetableCohortSize("11", monitor);
            }
            if ("sun.gc.generation.0.agetable.bytes.12".equals(name)) {
                return this.remarkAgetableCohortSize("12", monitor);
            }
            if ("sun.gc.generation.0.agetable.bytes.13".equals(name)) {
                return this.remarkAgetableCohortSize("13", monitor);
            }
            if ("sun.gc.generation.0.agetable.bytes.14".equals(name)) {
                return this.remarkAgetableCohortSize("14", monitor);
            }
            if ("sun.gc.generation.0.agetable.bytes.15".equals(name)) {
                return this.remarkAgetableCohortSize("15", monitor);
            }
            throw new UnknownMonitorError(monitor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean visitSurvivorSpaceAgetableCount(Monitor monitor) {
            Double value;
            if (this.agetableCount == null) {
                ManagedMemoryInstrumentation managedMemoryInstrumentation = this;
                synchronized (managedMemoryInstrumentation) {
                    if (!this.agetableCountOnce.getAndSet(true)) {
                        this.agetableCount = gaugePrototype.name("survivor_space_agetable_count").documentation("The number of survivor space agetable cohorts.").build();
                        this.notifyAll();
                    } else {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            if ((value = JvmstatMonitor.decodeMetric(monitor)) == null) {
                return false;
            }
            this.agetableCount.newPartial().apply().set(value.doubleValue());
            return true;
        }
    }

    public static class GarbageCollectionInstrumentation
    implements MonitorVisitor {
        private static final Gauge.Builder gaugePrototype = JvmstatMonitor.access$000().subsystem("garbage_collection");
        final AtomicBoolean invocationsOnce = new AtomicBoolean(false);
        final AtomicBoolean durationsOnce = new AtomicBoolean(false);
        @GuardedBy(value="invocationsOnce")
        private Gauge invocations;
        @GuardedBy(value="durationsOnce")
        private Gauge durations;

        @Override
        public boolean visit(String name, Monitor monitor) {
            if ("sun.gc.collector.0.invocations".equals(name) || "sun.gc.collector.1.invocations".equals(name)) {
                return this.visitInvocations(name, monitor);
            }
            if ("sun.gc.collector.0.time".equals(name) || "sun.gc.collector.1.time".equals(name)) {
                return this.visitDurations(name, monitor);
            }
            return false;
        }

        private boolean remarkInvocation(String generation, Monitor monitor) {
            Double value = JvmstatMonitor.decodeMetric(monitor);
            if (value == null) {
                return false;
            }
            this.invocations.newPartial().labelPair("generation", generation).apply().set(value.doubleValue());
            return true;
        }

        private boolean visitInvocations(String name, Monitor monitor) {
            if (this.invocations == null && !this.invocationsOnce.getAndSet(true)) {
                this.invocations = gaugePrototype.name("invocations_total").labelNames(new String[]{"generation"}).documentation("The total number of times the garbage collector has been invoked.").build();
            }
            if ("sun.gc.collector.0.invocations".equals(name)) {
                return this.remarkInvocation("new", monitor);
            }
            if ("sun.gc.collector.1.invocations".equals(name)) {
                return this.remarkInvocation("old", monitor);
            }
            throw new UnknownMonitorError(monitor);
        }

        private boolean remarkDuration(String generation, Monitor monitor) {
            Double valueMicros = JvmstatMonitor.decodeMetric(monitor);
            if (valueMicros == null) {
                return false;
            }
            Double valueMillis = valueMicros / 1000.0;
            this.durations.newPartial().labelPair("generation", generation).apply().set(valueMillis.doubleValue());
            return true;
        }

        private boolean visitDurations(String name, Monitor monitor) {
            if (this.durations == null && !this.durationsOnce.getAndSet(true)) {
                this.durations = gaugePrototype.name("durations_ms_total").documentation("The total time spent in garbage collection for a generation.").build();
            }
            if ("sun.gc.collector.0.time".equals(name)) {
                return this.remarkDuration("new", monitor);
            }
            if ("sun.gc.collector.1.time".equals(name)) {
                return this.remarkDuration("old", monitor);
            }
            throw new UnknownMonitorError(monitor);
        }
    }

    public static class NativeCodeCompilerInstrumentation
    implements MonitorVisitor {
        private static final Gauge.Builder gaugePrototype = JvmstatMonitor.access$000().subsystem("jit");
        private final AtomicBoolean compilationOnce = new AtomicBoolean(false);
        private final AtomicBoolean durationOnce = new AtomicBoolean(false);
        @GuardedBy(value="compilationsOnce")
        private Gauge compilations;
        @GuardedBy(value="durationsOnce")
        private Gauge durations;

        @Override
        public boolean visit(String name, Monitor monitor) {
            if ("sun.ci.compilerThread.0.compiles".equals(name) || "sun.ci.compilerThread.1.compiles".equals(name) || "sun.ci.compilerThread.2.compiles".equals(name)) {
                return this.visitCompilations(name, monitor);
            }
            if ("sun.ci.compilerThread.0.time".equals(name) || "sun.ci.compilerThread.1.time".equals(name) || "sun.ci.compilerThread.2.time".equals(name)) {
                return this.visitDurations(name, monitor);
            }
            return false;
        }

        private boolean remarkDuration(String thread, Monitor monitor) {
            Double value = JvmstatMonitor.decodeMetric(monitor);
            if (value == null) {
                return false;
            }
            this.durations.newPartial().labelPair("thread", thread).apply().set(value.doubleValue());
            return true;
        }

        private boolean visitDurations(String name, Monitor monitor) {
            if (this.durations == null && !this.durationOnce.getAndSet(true)) {
                this.durations = gaugePrototype.name("compilation_time_ms").documentation("The count of JIT compilation events.").labelNames(new String[]{"thread"}).build();
            }
            if ("sun.ci.compilerThread.0.time".equals(name)) {
                return this.remarkDuration("0", monitor);
            }
            if ("sun.ci.compilerThread.1.time".equals(name)) {
                return this.remarkDuration("1", monitor);
            }
            if ("sun.ci.compilerThread.2.time".equals(name)) {
                return this.remarkDuration("2", monitor);
            }
            throw new UnknownMonitorError(monitor);
        }

        private boolean remarkCompilation(String thread, Monitor monitor) {
            Double value = JvmstatMonitor.decodeMetric(monitor);
            if (value == null) {
                return false;
            }
            this.compilations.newPartial().labelPair("thread", thread).apply().set(value.doubleValue());
            return true;
        }

        private boolean visitCompilations(String name, Monitor monitor) {
            if (this.compilations == null && !this.compilationOnce.getAndSet(true)) {
                this.compilations = gaugePrototype.name("compilation_count").documentation("The count of JIT compilation events.").labelNames(new String[]{"thread"}).build();
            }
            if ("sun.ci.compilerThread.0.compiles".equals(name)) {
                return this.remarkCompilation("0", monitor);
            }
            if ("sun.ci.compilerThread.1.compiles".equals(name)) {
                return this.remarkCompilation("1", monitor);
            }
            if ("sun.ci.compilerThread.1.compiles".equals(name)) {
                return this.remarkCompilation("2", monitor);
            }
            throw new UnknownMonitorError(monitor);
        }
    }

    public static class ClassLoaderInstrumentation
    implements MonitorVisitor {
        private static final Gauge.Builder gaugePrototype = JvmstatMonitor.access$000().subsystem("classloader");
        private final AtomicBoolean statesOnce = new AtomicBoolean(false);
        private final AtomicBoolean sizesOnce = new AtomicBoolean(false);
        private final AtomicBoolean durationsOnce = new AtomicBoolean(false);
        @GuardedBy(value="statesOnce")
        private Gauge states;
        @GuardedBy(value="sizesOnce")
        private Gauge sizes;
        @GuardedBy(value="durationsOnce")
        private Gauge durations;

        @Override
        public boolean visit(String name, Monitor monitor) {
            if ("java.cls.loadedClasses".equals(name) || "java.cls.unloadedClasses".equals(name) || "sun.cls.initializedClasses".equals(name)) {
                return this.visitClassEvents(name, monitor);
            }
            if ("sun.cls.loadedBytes".equals(name)) {
                return this.visitSizes(monitor);
            }
            if ("sun.classloader.findClassTime".equals(name) || "sun.cls.parseClassTime".equals(name)) {
                return this.visitDurations(name, monitor);
            }
            return false;
        }

        private boolean remarkDuration(String duration, Monitor monitor) {
            Double value = JvmstatMonitor.decodeMetric(monitor);
            if (value == null) {
                return false;
            }
            this.durations.newPartial().labelPair("operation", duration).apply().set(value.doubleValue());
            return true;
        }

        private boolean visitDurations(String name, Monitor monitor) {
            if (this.durations == null && !this.durationsOnce.getAndSet(true)) {
                this.durations = gaugePrototype.name("duration_ms").documentation("The time it has taken the classloader to perform loadings partitioned by operation.").labelNames(new String[]{"operation"}).build();
            }
            if ("sun.classloader.findClassTime".equals(name)) {
                return this.remarkDuration("find", monitor);
            }
            if ("sun.cls.parseClassTime".equals(name)) {
                return this.remarkDuration("parse", monitor);
            }
            throw new UnknownMonitorError(monitor);
        }

        private boolean visitSizes(Monitor monitor) {
            Double value;
            if (this.sizes == null && !this.sizesOnce.getAndSet(true)) {
                this.sizes = gaugePrototype.name("loaded_bytes").documentation("The number of bytes the classloader has loaded.").build();
            }
            if ((value = JvmstatMonitor.decodeMetric(monitor)) == null) {
                return false;
            }
            this.sizes.newPartial().apply().set(value.doubleValue());
            return true;
        }

        private boolean remarkClassEvent(String event, Monitor monitor) {
            Double value = JvmstatMonitor.decodeMetric(monitor);
            if (value == null) {
                return false;
            }
            this.states.newPartial().labelPair("event", event).apply().set(value.doubleValue());
            return true;
        }

        private boolean visitClassEvents(String name, Monitor monitor) {
            if (this.states == null && !this.statesOnce.getAndSet(true)) {
                this.states = gaugePrototype.name("operations_total").documentation("The number of classes the loader has touched by disposition.").labelNames(new String[]{"event"}).build();
            }
            if ("java.cls.loadedClasses".equals(name)) {
                return this.remarkClassEvent("loaded", monitor);
            }
            if ("java.cls.unloadedClasses".equals(name)) {
                return this.remarkClassEvent("unloaded", monitor);
            }
            if ("sun.cls.initializedClasses".equals(name)) {
                return this.remarkClassEvent("initialized", monitor);
            }
            throw new UnknownMonitorError(monitor);
        }
    }

    static class UnknownMonitorError
    extends IllegalArgumentException {
        UnknownMonitorError(Monitor m) {
            super(String.format("unhandled jvmstat monitor: %s", m.getName()));
        }
    }

    public static class AttachmentError
    extends Exception {
        AttachmentError(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

