/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client.utility.jvmstat;

import io.prometheus.client.Prometheus;
import io.prometheus.client.metrics.Gauge;
import java.lang.management.ManagementFactory;
import java.net.URISyntaxException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import java.util.regex.PatternSyntaxException;
import sun.jvmstat.monitor.HostIdentifier;
import sun.jvmstat.monitor.Monitor;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.MonitoredHost;
import sun.jvmstat.monitor.MonitoredVm;
import sun.jvmstat.monitor.VmIdentifier;

public class JvmstatMonitor
implements Prometheus.ExpositionHook {
    private static final int REFRESH_INTERVAL = 5;
    private static final Gauge.Builder gaugePrototype = Gauge.newBuilder().namespace("jvmstat");
    private static final Logger log = Logger.getLogger(JvmstatMonitor.class.getName());
    private final MonitoredVm bridge;
    private final MonitorVisitor clsInstrumentation = new ClassLoaderInstrumentation();
    private final MonitorVisitor nccInstrumentation = new NativeCodeCompilerInstrumentation();
    private final MonitorVisitor gcInstrumentation = new GarbageCollectionInstrumentation();
    private final MonitorVisitor mmInstrumentation = new ManagedMemoryInstrumentation();
    private final AtomicInteger refreshes = new AtomicInteger(0);
    private final ConcurrentHashMap<String, Monitor> monitors = new ConcurrentHashMap(400);

    public JvmstatMonitor() throws AttachmentError {
        this(JvmstatMonitor.getLocalVM());
    }

    public JvmstatMonitor(MonitoredVm b) {
        this.bridge = b;
    }

    private void refreshMetrics() {
        List<Monitor> monitors;
        try {
            monitors = this.bridge.findByPattern(".*");
        }
        catch (MonitorException ex) {
            log.warning(String.format("could not extract telemetry: %s", ex));
            return;
        }
        catch (PatternSyntaxException ex) {
            log.warning(String.format("could not extract telemetry: %s", ex));
            return;
        }
        if (monitors == null) {
            return;
        }
        for (Monitor monitor : monitors) {
            this.monitors.putIfAbsent(monitor.getName(), monitor);
        }
    }

    public void run() {
        if (this.refreshes.getAndIncrement() % 5 == 0) {
            this.refreshMetrics();
        }
        for (String monitorName : this.monitors.keySet()) {
            Monitor monitor;
            if (!this.clsInstrumentation.visit(monitorName, monitor = this.monitors.get(monitorName)) && !this.nccInstrumentation.visit(monitorName, monitor) && !this.gcInstrumentation.visit(monitorName, monitor) && !this.mmInstrumentation.visit(monitorName, monitor)) continue;
        }
    }

    private static MonitoredVm getLocalVM() throws AttachmentError {
        int pid;
        String name = ManagementFactory.getRuntimeMXBean().getName();
        int pidOffset = name.indexOf(64);
        try {
            pid = Integer.valueOf(name.substring(0, pidOffset));
        }
        catch (IndexOutOfBoundsException ex) {
            throw new AttachmentError("illegal instance name", ex);
        }
        catch (NumberFormatException ex) {
            throw new AttachmentError("illegal instance name format", ex);
        }
        try {
            HostIdentifier hostId = new HostIdentifier((String)null);
            MonitoredHost host = MonitoredHost.getMonitoredHost(hostId);
            String localAddr = String.format("//%d?mode=r", pid);
            VmIdentifier id = new VmIdentifier(localAddr);
            return host.getMonitoredVm(id);
        }
        catch (URISyntaxException ex) {
            throw new AttachmentError("invalid target URI", ex);
        }
        catch (MonitorException ex) {
            throw new AttachmentError("could not resolve host", ex);
        }
    }

    private static Double decodeMetric(Monitor m) {
        Object value = m.getValue();
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            return (double)((Long)value);
        }
        try {
            return Double.valueOf(value.toString());
        }
        catch (NumberFormatException unused) {
            return null;
        }
    }

    static /* synthetic */ Gauge.Builder access$000() {
        return gaugePrototype;
    }

    static interface MonitorVisitor {
        public boolean visit(String var1, Monitor var2);
    }

    public static class ManagedMemoryInstrumentation
    implements MonitorVisitor {
        private static final Gauge.Builder gaugePrototype = JvmstatMonitor.access$000().subsystem("managed_memory");
        private final AtomicBoolean agetableCohortsOnce = new AtomicBoolean(false);
        private final AtomicBoolean agetableCountOnce = new AtomicBoolean(false);
        private final AtomicBoolean generationLimitOnce = new AtomicBoolean(false);
        private final AtomicBoolean generationUsageOnce = new AtomicBoolean(false);
        private Gauge agetableCohorts;
        private Gauge agetableCount;
        private Gauge generationLimit;
        private Gauge generationUsage;

        @Override
        public boolean visit(String name, Monitor monitor) {
            switch (name) {
                case "sun.gc.generation.0.agetable.bytes.00": 
                case "sun.gc.generation.0.agetable.bytes.01": 
                case "sun.gc.generation.0.agetable.bytes.02": 
                case "sun.gc.generation.0.agetable.bytes.03": 
                case "sun.gc.generation.0.agetable.bytes.04": 
                case "sun.gc.generation.0.agetable.bytes.05": 
                case "sun.gc.generation.0.agetable.bytes.06": 
                case "sun.gc.generation.0.agetable.bytes.07": 
                case "sun.gc.generation.0.agetable.bytes.08": 
                case "sun.gc.generation.0.agetable.bytes.09": 
                case "sun.gc.generation.0.agetable.bytes.10": 
                case "sun.gc.generation.0.agetable.bytes.11": 
                case "sun.gc.generation.0.agetable.bytes.12": 
                case "sun.gc.generation.0.agetable.bytes.13": 
                case "sun.gc.generation.0.agetable.bytes.14": 
                case "sun.gc.generation.0.agetable.bytes.15": {
                    return this.visitSurvivorSpaceAgetableCohorts(name, monitor);
                }
                case "sun.gc.generation.0.agetable.size": {
                    return this.visitSurvivorSpaceAgetableCount(monitor);
                }
                case "sun.gc.generation.0.space.0.capacity": 
                case "sun.gc.generation.0.space.1.capacity": 
                case "sun.gc.generation.0.space.2.capacity": 
                case "sun.gc.generation.1.space.0.capacity": 
                case "sun.gc.generation.2.space.0.capacity": {
                    return this.visitGenerationLimits(name, monitor);
                }
                case "sun.gc.generation.0.space.0.used": 
                case "sun.gc.generation.0.space.1.used": 
                case "sun.gc.generation.0.space.2.used": 
                case "sun.gc.generation.1.space.0.used": 
                case "sun.gc.generation.2.space.0.used": {
                    return this.visitGenerationUsage(name, monitor);
                }
            }
            return false;
        }

        private boolean remarkGenerationLimit(String generation, Monitor monitor) {
            Double value = JvmstatMonitor.decodeMetric(monitor);
            if (value == null) {
                return false;
            }
            this.generationLimit.newPartial().labelPair("generation", generation).apply().set(value.doubleValue());
            return true;
        }

        private boolean visitGenerationLimits(String name, Monitor monitor) {
            if (this.generationLimit == null && !this.generationLimitOnce.getAndSet(true)) {
                this.generationLimit = gaugePrototype.name("generation_limit_bytes").labelNames(new String[]{"generation"}).documentation("The total allocation/reservation of each managed memory region or generation.").build();
            }
            switch (name) {
                case "sun.gc.generation.0.space.0.capacity": {
                    return this.remarkGenerationLimit("eden", monitor);
                }
                case "sun.gc.generation.0.space.1.capacity": {
                    return this.remarkGenerationLimit("survivor0", monitor);
                }
                case "sun.gc.generation.0.space.2.capacity": {
                    return this.remarkGenerationLimit("survivor1", monitor);
                }
                case "sun.gc.generation.1.space.0.capacity": {
                    return this.remarkGenerationLimit("old", monitor);
                }
                case "sun.gc.generation.2.space.0.capacity": {
                    return this.remarkGenerationLimit("permgen", monitor);
                }
            }
            throw new UnknownMonitorError(monitor);
        }

        private boolean remarkGenerationUsage(String generation, Monitor monitor) {
            Double value = JvmstatMonitor.decodeMetric(monitor);
            if (value == null) {
                return false;
            }
            this.generationUsage.newPartial().labelPair("generation", generation).apply().set(value.doubleValue());
            return true;
        }

        private boolean visitGenerationUsage(String name, Monitor monitor) {
            if (this.generationUsage == null && !this.generationUsageOnce.getAndSet(true)) {
                this.generationUsage = gaugePrototype.name("generation_usage_bytes").labelNames(new String[]{"generation"}).documentation("The size used of each managed memory region or generation.").build();
            }
            switch (name) {
                case "sun.gc.generation.0.space.0.used": {
                    return this.remarkGenerationUsage("eden", monitor);
                }
                case "sun.gc.generation.0.space.1.used": {
                    return this.remarkGenerationUsage("survivor0", monitor);
                }
                case "sun.gc.generation.0.space.2.used": {
                    return this.remarkGenerationUsage("survivor1", monitor);
                }
                case "sun.gc.generation.1.space.0.used": {
                    return this.remarkGenerationUsage("old", monitor);
                }
                case "sun.gc.generation.2.space.0.used": {
                    return this.remarkGenerationUsage("permgen", monitor);
                }
            }
            throw new UnknownMonitorError(monitor);
        }

        private boolean remarkAgetableCohortSize(String cohort, Monitor monitor) {
            Double value = JvmstatMonitor.decodeMetric(monitor);
            if (value == null) {
                return false;
            }
            this.agetableCohorts.newPartial().labelPair("cohort", cohort).apply().set(value.doubleValue());
            return true;
        }

        private boolean visitSurvivorSpaceAgetableCohorts(String name, Monitor monitor) {
            if (this.agetableCohorts == null && !this.agetableCohortsOnce.getAndSet(true)) {
                this.agetableCohorts = gaugePrototype.name("survivor_space_agetable_size_bytes").labelNames(new String[]{"cohort"}).documentation("A measure of the size of each survivor space agetable cohort.").build();
            }
            switch (name) {
                case "sun.gc.generation.0.agetable.bytes.00": {
                    return this.remarkAgetableCohortSize("00", monitor);
                }
                case "sun.gc.generation.0.agetable.bytes.01": {
                    return this.remarkAgetableCohortSize("01", monitor);
                }
                case "sun.gc.generation.0.agetable.bytes.02": {
                    return this.remarkAgetableCohortSize("02", monitor);
                }
                case "sun.gc.generation.0.agetable.bytes.03": {
                    return this.remarkAgetableCohortSize("03", monitor);
                }
                case "sun.gc.generation.0.agetable.bytes.04": {
                    return this.remarkAgetableCohortSize("04", monitor);
                }
                case "sun.gc.generation.0.agetable.bytes.05": {
                    return this.remarkAgetableCohortSize("05", monitor);
                }
                case "sun.gc.generation.0.agetable.bytes.06": {
                    return this.remarkAgetableCohortSize("06", monitor);
                }
                case "sun.gc.generation.0.agetable.bytes.07": {
                    return this.remarkAgetableCohortSize("07", monitor);
                }
                case "sun.gc.generation.0.agetable.bytes.08": {
                    return this.remarkAgetableCohortSize("08", monitor);
                }
                case "sun.gc.generation.0.agetable.bytes.09": {
                    return this.remarkAgetableCohortSize("09", monitor);
                }
                case "sun.gc.generation.0.agetable.bytes.10": {
                    return this.remarkAgetableCohortSize("10", monitor);
                }
                case "sun.gc.generation.0.agetable.bytes.11": {
                    return this.remarkAgetableCohortSize("11", monitor);
                }
                case "sun.gc.generation.0.agetable.bytes.12": {
                    return this.remarkAgetableCohortSize("12", monitor);
                }
                case "sun.gc.generation.0.agetable.bytes.13": {
                    return this.remarkAgetableCohortSize("13", monitor);
                }
                case "sun.gc.generation.0.agetable.bytes.14": {
                    return this.remarkAgetableCohortSize("14", monitor);
                }
                case "sun.gc.generation.0.agetable.bytes.15": {
                    return this.remarkAgetableCohortSize("15", monitor);
                }
            }
            throw new UnknownMonitorError(monitor);
        }

        private boolean visitSurvivorSpaceAgetableCount(Monitor monitor) {
            Double value;
            if (this.agetableCount == null && !this.agetableCountOnce.getAndSet(true)) {
                this.agetableCount = gaugePrototype.name("survivor_space_agetable_count").documentation("The number of survivor space agetable cohorts.").build();
            }
            if ((value = JvmstatMonitor.decodeMetric(monitor)) == null) {
                return false;
            }
            this.agetableCount.newPartial().apply().set(value.doubleValue());
            return true;
        }
    }

    public static class GarbageCollectionInstrumentation
    implements MonitorVisitor {
        private static final Gauge.Builder gaugePrototype = JvmstatMonitor.access$000().subsystem("garbage_collection");
        final AtomicBoolean invocationsOnce = new AtomicBoolean(false);
        final AtomicBoolean durationsOnce = new AtomicBoolean(false);
        Gauge invocations;
        Gauge durations;

        @Override
        public boolean visit(String name, Monitor monitor) {
            switch (name) {
                case "sun.gc.collector.0.invocations": 
                case "sun.gc.collector.1.invocations": {
                    return this.visitInvocations(name, monitor);
                }
                case "sun.gc.collector.0.time": 
                case "sun.gc.collector.1.time": {
                    return this.visitDurations(name, monitor);
                }
            }
            return false;
        }

        private boolean remarkInvocation(String generation, Monitor monitor) {
            Double value = JvmstatMonitor.decodeMetric(monitor);
            if (value == null) {
                return false;
            }
            this.invocations.newPartial().labelPair("generation", generation).apply().set(value.doubleValue());
            return true;
        }

        private boolean visitInvocations(String name, Monitor monitor) {
            if (this.invocations == null && !this.invocationsOnce.getAndSet(true)) {
                this.invocations = gaugePrototype.name("invocations_total").labelNames(new String[]{"generation"}).documentation("The total number of times the garbage collector has been invoked.").build();
            }
            switch (name) {
                case "sun.gc.collector.0.invocations": {
                    return this.remarkInvocation("new", monitor);
                }
                case "sun.gc.collector.1.invocations": {
                    return this.remarkInvocation("old", monitor);
                }
            }
            throw new UnknownMonitorError(monitor);
        }

        private boolean remarkDuration(String generation, Monitor monitor) {
            Double valueMicros = JvmstatMonitor.decodeMetric(monitor);
            if (valueMicros == null) {
                return false;
            }
            Double valueMillis = valueMicros / 1000.0;
            this.durations.newPartial().labelPair("generation", generation).apply().set(valueMillis.doubleValue());
            return true;
        }

        private boolean visitDurations(String name, Monitor monitor) {
            if (this.durations == null && !this.durationsOnce.getAndSet(true)) {
                this.durations = gaugePrototype.name("durations_ms_total").documentation("The total time spent in garbage collection for a generation.").build();
            }
            switch (name) {
                case "sun.gc.collector.0.time": {
                    return this.remarkDuration("new", monitor);
                }
                case "sun.gc.collector.1.time": {
                    return this.remarkDuration("old", monitor);
                }
            }
            throw new UnknownMonitorError(monitor);
        }
    }

    public static class NativeCodeCompilerInstrumentation
    implements MonitorVisitor {
        private static final Gauge.Builder gaugePrototype = JvmstatMonitor.access$000().subsystem("jit");
        private final AtomicBoolean compilationOnce = new AtomicBoolean(false);
        private final AtomicBoolean durationOnce = new AtomicBoolean(false);
        private Gauge compilations;
        private Gauge durations;

        @Override
        public boolean visit(String name, Monitor monitor) {
            switch (name) {
                case "sun.ci.compilerThread.0.compiles": 
                case "sun.ci.compilerThread.1.compiles": 
                case "sun.ci.compilerThread.2.compiles": {
                    return this.visitCompilations(name, monitor);
                }
                case "sun.ci.compilerThread.0.time": 
                case "sun.ci.compilerThread.1.time": 
                case "sun.ci.compilerThread.2.time": {
                    return this.visitDurations(name, monitor);
                }
            }
            return false;
        }

        private boolean remarkDuration(String thread, Monitor monitor) {
            Double value = JvmstatMonitor.decodeMetric(monitor);
            if (value == null) {
                return false;
            }
            this.durations.newPartial().labelPair("thread", thread).apply().set(value.doubleValue());
            return true;
        }

        private boolean visitDurations(String name, Monitor monitor) {
            if (this.durations == null && !this.durationOnce.getAndSet(true)) {
                this.durations = gaugePrototype.name("compilation_time_ms").documentation("The count of JIT compilation events.").labelNames(new String[]{"thread"}).build();
            }
            switch (name) {
                case "sun.ci.compilerThread.0.time": {
                    return this.remarkDuration("0", monitor);
                }
                case "sun.ci.compilerThread.1.time": {
                    return this.remarkDuration("1", monitor);
                }
                case "sun.ci.compilerThread.2.time": {
                    return this.remarkDuration("2", monitor);
                }
            }
            throw new UnknownMonitorError(monitor);
        }

        private boolean remarkCompilation(String thread, Monitor monitor) {
            Double value = JvmstatMonitor.decodeMetric(monitor);
            if (value == null) {
                return false;
            }
            this.compilations.newPartial().labelPair("thread", thread).apply().set(value.doubleValue());
            return true;
        }

        private boolean visitCompilations(String name, Monitor monitor) {
            if (this.compilations == null && !this.compilationOnce.getAndSet(true)) {
                this.compilations = gaugePrototype.name("compilation_count").documentation("The count of JIT compilation events.").labelNames(new String[]{"thread"}).build();
            }
            switch (name) {
                case "sun.ci.compilerThread.0.compiles": {
                    return this.remarkCompilation("0", monitor);
                }
                case "sun.ci.compilerThread.1.compiles": {
                    return this.remarkCompilation("1", monitor);
                }
                case "sun.ci.compilerThread.2.compiles": {
                    return this.remarkCompilation("2", monitor);
                }
            }
            throw new UnknownMonitorError(monitor);
        }
    }

    public static class ClassLoaderInstrumentation
    implements MonitorVisitor {
        private static final Gauge.Builder gaugePrototype = JvmstatMonitor.access$000().subsystem("classloader");
        private final AtomicBoolean statesOnce = new AtomicBoolean(false);
        private final AtomicBoolean sizesOnce = new AtomicBoolean(false);
        private final AtomicBoolean durationsOnce = new AtomicBoolean(false);
        private Gauge states;
        private Gauge sizes;
        private Gauge durations;

        @Override
        public boolean visit(String name, Monitor monitor) {
            switch (name) {
                case "java.cls.loadedClasses": 
                case "java.cls.unloadedClasses": 
                case "sun.cls.initializedClasses": {
                    return this.visitClassEvents(name, monitor);
                }
                case "sun.cls.loadedBytes": {
                    return this.visitSizes(monitor);
                }
                case "sun.classloader.findClassTime": 
                case "sun.cls.parseClassTime": {
                    return this.visitDurations(name, monitor);
                }
            }
            return false;
        }

        private boolean remarkDuration(String duration, Monitor monitor) {
            Double value = JvmstatMonitor.decodeMetric(monitor);
            if (value == null) {
                return false;
            }
            this.durations.newPartial().labelPair("operation", duration).apply().set(value.doubleValue());
            return true;
        }

        private boolean visitDurations(String name, Monitor monitor) {
            if (this.durations == null && !this.durationsOnce.getAndSet(true)) {
                this.durations = gaugePrototype.name("duration_ms").documentation("The time it has taken the classloader to perform loadings partitioned by operation.").labelNames(new String[]{"operation"}).build();
            }
            switch (name) {
                case "sun.classloader.findClassTime": {
                    return this.remarkDuration("find", monitor);
                }
                case "sun.cls.parseClassTime": {
                    return this.remarkDuration("parse", monitor);
                }
            }
            throw new UnknownMonitorError(monitor);
        }

        private boolean visitSizes(Monitor monitor) {
            Double value;
            if (this.sizes == null && !this.sizesOnce.getAndSet(true)) {
                this.sizes = gaugePrototype.name("loaded_bytes").documentation("The number of bytes the classloader has loaded.").build();
            }
            if ((value = JvmstatMonitor.decodeMetric(monitor)) == null) {
                return false;
            }
            this.sizes.newPartial().apply().set(value.doubleValue());
            return true;
        }

        private boolean remarkClassEvent(String event, Monitor monitor) {
            Double value = JvmstatMonitor.decodeMetric(monitor);
            if (value == null) {
                return false;
            }
            this.states.newPartial().labelPair("event", event).apply().set(value.doubleValue());
            return true;
        }

        private boolean visitClassEvents(String name, Monitor monitor) {
            if (this.states == null && !this.statesOnce.getAndSet(true)) {
                this.states = gaugePrototype.name("operations_total").documentation("The number of classes the loader has touched by disposition.").labelNames(new String[]{"event"}).build();
            }
            switch (name) {
                case "java.cls.loadedClasses": {
                    return this.remarkClassEvent("loaded", monitor);
                }
                case "java.cls.unloadedClasses": {
                    return this.remarkClassEvent("unloaded", monitor);
                }
                case "sun.cls.initializedClasses": {
                    return this.remarkClassEvent("initialized", monitor);
                }
            }
            throw new UnknownMonitorError(monitor);
        }
    }

    static class UnknownMonitorError
    extends IllegalArgumentException {
        UnknownMonitorError(Monitor m) {
            super(String.format("unhandled jvmstat monitor: %s", m.getName()));
        }
    }

    public static class AttachmentError
    extends Exception {
        AttachmentError(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

