/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client.examples.random;

import io.prometheus.client.Prometheus;
import io.prometheus.client.Register;
import io.prometheus.client.metrics.Counter;
import io.prometheus.client.metrics.Summary;
import io.prometheus.client.utility.servlet.MetricsServlet;
import java.util.concurrent.TimeUnit;
import javax.servlet.Servlet;
import org.apache.commons.math3.random.RandomDataImpl;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class Main {
    @Register
    private static final Counter rpcCalls = Counter.newBuilder().namespace("rpc").name("calls_total").documentation("The total number of RPC calls partitioned by RPC service.").build();
    @Register
    private static final Summary rpcLatency = Summary.newBuilder().namespace("rpc").name("latency_microseconds").documentation("RPC latency partitioned by RPC service.").targetQuantile(Double.valueOf(0.01), Double.valueOf(0.001)).targetQuantile(Double.valueOf(0.05), Double.valueOf(0.025)).targetQuantile(Double.valueOf(0.5), Double.valueOf(0.05)).targetQuantile(Double.valueOf(0.9), Double.valueOf(0.01)).targetQuantile(Double.valueOf(0.99), Double.valueOf(0.001)).purgeInterval(2, TimeUnit.MINUTES).build();

    public static void main(String[] arguments) {
        Prometheus.defaultInitialize();
        Server server = new Server(8080);
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/");
        server.setHandler((Handler)context);
        context.addServlet(new ServletHolder((Servlet)new MetricsServlet()), "/");
        new Thread(){

            @Override
            public void run() {
                RandomDataImpl randomData = new RandomDataImpl();
                try {
                    while (true) {
                        rpcLatency.newPartial().labelPair("service", "foo").apply().observe(Double.valueOf(randomData.nextLong(0L, 200L)));
                        rpcLatency.newPartial().labelPair("service", "bar").apply().observe(Double.valueOf(randomData.nextGaussian(100.0, 20.0)));
                        rpcLatency.newPartial().labelPair("service", "zed").apply().observe(Double.valueOf(randomData.nextExponential(100.0)));
                        rpcCalls.newPartial().labelPair("service", "foo").apply().increment();
                        rpcCalls.newPartial().labelPair("service", "bar").apply().increment();
                        rpcCalls.newPartial().labelPair("service", "zed").apply().increment();
                        Thread.sleep(250L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        }.start();
        try {
            server.start();
            server.join();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

