/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client.examples.random;

import io.prometheus.client.Prometheus;
import io.prometheus.client.Register;
import io.prometheus.client.metrics.Counter;
import io.prometheus.client.metrics.Summary;
import io.prometheus.client.utility.servlet.MetricsServlet;
import javax.servlet.Servlet;
import org.apache.commons.math3.random.RandomDataImpl;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.joda.time.ReadableDuration;
import org.joda.time.Seconds;

public class Main {
    @Register
    private static final Counter rpcCalls = Counter.builder().inNamespace("rpc").named("calls_total").documentedAs("The total number of RPC calls partitioned by RPC service.").build();
    @Register
    private static final Summary rpcLatency = Summary.builder().inNamespace("rpc").named("latency_microseconds").documentedAs("RPC latency partitioned by RPC service.").withTarget(Double.valueOf(0.01), Double.valueOf(0.001)).withTarget(Double.valueOf(0.05), Double.valueOf(0.025)).withTarget(Double.valueOf(0.5), Double.valueOf(0.05)).withTarget(Double.valueOf(0.9), Double.valueOf(0.01)).withTarget(Double.valueOf(0.99), Double.valueOf(0.001)).purgesEvery(15, (ReadableDuration)Seconds.ONE.toStandardDuration()).build();

    public static void main(String[] arguments) {
        Prometheus.defaultInitialize();
        Server server = new Server(8181);
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/");
        server.setHandler((Handler)context);
        context.addServlet(new ServletHolder((Servlet)new MetricsServlet()), "/");
        new Thread(){

            @Override
            public void run() {
                RandomDataImpl randomData = new RandomDataImpl();
                try {
                    while (true) {
                        rpcLatency.newPartial().withDimension("service", "foo").apply().observe(Double.valueOf(randomData.nextLong(0L, 200L)));
                        rpcLatency.newPartial().withDimension("service", "bar").apply().observe(Double.valueOf(randomData.nextGaussian(100.0, 20.0)));
                        rpcLatency.newPartial().withDimension("service", "zed").apply().observe(Double.valueOf(randomData.nextExponential(100.0)));
                        rpcCalls.newPartial().withDimension("service", "foo").apply().increment();
                        rpcCalls.newPartial().withDimension("service", "bar").apply().increment();
                        rpcCalls.newPartial().withDimension("service", "zed").apply().increment();
                        Thread.sleep(250L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        }.start();
        try {
            server.start();
            server.join();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

