/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client.examples.guice.servlet;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import io.prometheus.client.metrics.Counter;
import io.prometheus.client.metrics.Summary;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Singleton
public class FooServlet
extends HttpServlet {
    private final Counter.Partial requestPartial;
    private final Summary.Partial latencyPartial;

    @Inject
    public FooServlet(@Named(value="handler") Counter requests, @Named(value="handler") Summary latencies) {
        this.requestPartial = requests.newPartial().labelPair("handler", "foo");
        this.latencyPartial = latencies.newPartial().labelPair("handler", "foo");
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        long start = System.currentTimeMillis();
        Counter.Partial count = this.requestPartial.clone();
        Summary.Partial latency = this.latencyPartial.clone();
        try {
            resp.setStatus(200);
            resp.getWriter().write("Here's one foo for you!");
            count.labelPair("result", "success");
            latency.labelPair("result", "success");
        }
        catch (IOException e) {
            count.labelPair("result", "failure");
            latency.labelPair("result", "failure");
            throw e;
        }
        catch (RuntimeException e) {
            count.labelPair("result", "failure");
            latency.labelPair("result", "failure");
            throw e;
        }
        finally {
            long dur = System.currentTimeMillis() - start;
            count.apply().increment();
            latency.apply().observe(Double.valueOf(dur));
        }
    }
}

