/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client.examples.guice;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.prometheus.client.Prometheus;
import io.prometheus.client.examples.guice.servlet.BarServlet;
import io.prometheus.client.examples.guice.servlet.FooServlet;
import io.prometheus.client.utility.servlet.MetricsServlet;
import java.util.Set;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

@Singleton
public class Server {
    private final org.eclipse.jetty.server.Server server;
    private final FooServlet foo;
    private final BarServlet bar;
    private final Set<Prometheus.ExpositionHook> hooks;

    @Inject
    public Server(org.eclipse.jetty.server.Server server, FooServlet foo, BarServlet bar, Set<Prometheus.ExpositionHook> hooks) {
        this.server = server;
        this.foo = foo;
        this.bar = bar;
        this.hooks = hooks;
    }

    public void configure() {
        for (Prometheus.ExpositionHook hook : this.hooks) {
            Prometheus.defaultAddPreexpositionHook((Prometheus.ExpositionHook)hook);
        }
        Prometheus.defaultInitialize();
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/");
        this.server.setHandler((Handler)context);
        context.addServlet(new ServletHolder((Servlet)this.foo), "/foo");
        context.addServlet(new ServletHolder((Servlet)this.bar), "/bar");
        context.addServlet(new ServletHolder((Servlet)new MetricsServlet()), "/metrics");
    }

    public void run() {
        try {
            this.server.start();
            this.server.join();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

