/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client.examples.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import io.prometheus.client.Prometheus;
import io.prometheus.client.metrics.Counter;
import io.prometheus.client.metrics.Summary;
import java.lang.annotation.Annotation;
import org.eclipse.jetty.server.Server;

public class Module
extends AbstractModule {
    private static final Counter.Builder COUNTER_PROTOTYPE = Counter.newBuilder().namespace("guice_example");
    private static final Summary.Builder SUMMARY_PROTOTYPE = Summary.newBuilder().namespace("guice_example");

    protected void configure() {
        this.bind(Integer.class).annotatedWith((Annotation)Names.named((String)"port")).toInstance((Object)8080);
        this.bind(Counter.class).annotatedWith((Annotation)Names.named((String)"handler")).toProvider(HandlerCounterProvider.class).in(Singleton.class);
        this.bind(Summary.class).annotatedWith((Annotation)Names.named((String)"handler")).toProvider(HandlerLatencyProvider.class).in(Singleton.class);
        Multibinder hooks = Multibinder.newSetBinder((Binder)this.binder(), Prometheus.ExpositionHook.class);
    }

    @Provides
    @Singleton
    public Server getServer(@Named(value="port") Integer port) {
        return new Server(port.intValue());
    }

    public static class HandlerLatencyProvider
    implements Provider<Summary> {
        public Summary get() {
            return SUMMARY_PROTOTYPE.subsystem("http").name("latency_ms").labelNames(new String[]{"handler"}).labelNames(new String[]{"result"}).documentation("The latencies of the requests served.").build();
        }
    }

    public static class HandlerCounterProvider
    implements Provider<Counter> {
        public Counter get() {
            return COUNTER_PROTOTYPE.subsystem("http").name("requests_total").labelNames(new String[]{"handler"}).labelNames(new String[]{"result"}).documentation("The total number of requests served.").build();
        }
    }
}

