/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client.metrics;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import io.prometheus.client.Metrics;
import io.prometheus.client.Prometheus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.NotThreadSafe;
import net.jcip.annotations.ThreadSafe;

public abstract class Metric<M extends Metric, C extends Child, P extends Partial> {
    private static final String PRIVATE_LABEL_NAMESPACE = "__";
    static final String SERIALIZE_BASE_LABELS = "baseLabels";
    static final String SERIALIZE_DOCSTRING = "docstring";
    static final String SERIALIZE_METRIC = "metric";
    private final List<String> labelNames;
    private final Metrics.MetricFamily partial;
    final String name;
    final String docstring;
    final ConcurrentHashMap<Map<String, String>, C> children = new ConcurrentHashMap();

    protected Metric(String n, String d, List<String> ds, Metrics.MetricFamily p, boolean rs) {
        this.name = n;
        this.docstring = d;
        this.labelNames = ds;
        this.partial = p;
        if (rs) {
            Prometheus.defaultRegister(this);
        }
    }

    Metrics.MetricFamily.Builder getPartialBuilder() {
        return Metrics.MetricFamily.newBuilder((Metrics.MetricFamily)this.partial);
    }

    abstract Metrics.MetricFamily.Builder annotateBuilder(Metrics.MetricFamily.Builder var1);

    public Metrics.MetricFamily dump() {
        return this.annotateBuilder(this.getPartialBuilder()).build();
    }

    public void resetAll() {
        Iterator<C> i$ = this.children.values().iterator();
        while (i$.hasNext()) {
            Child child;
            Child cast = child = (Child)i$.next();
            cast.reset();
        }
    }

    private void disbandChildren() {
        this.children.clear();
    }

    public abstract P newPartial();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Metric)) {
            return false;
        }
        Metric metric = (Metric)o;
        if (!this.labelNames.equals(metric.labelNames)) {
            return false;
        }
        if (!this.docstring.equals(metric.docstring)) {
            return false;
        }
        return this.name.equals(metric.name);
    }

    public int hashCode() {
        int result = this.labelNames.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.docstring.hashCode();
        return result;
    }

    public String toString() {
        return String.format("Metric{name='%s', labelNames=%s}", this.name, this.labelNames);
    }

    public static class IllegalLabelDeclarationException
    extends IllegalArgumentException {
        private IllegalLabelDeclarationException(String msg) {
            super(msg);
        }

        static IllegalLabelDeclarationException reserved(String labelName, String metricName) {
            return new IllegalLabelDeclarationException(String.format("metric %s's label of %s begins with reserved prefix %s", metricName, labelName, Metric.PRIVATE_LABEL_NAMESPACE));
        }

        static IllegalLabelDeclarationException empty(String metricName) {
            return new IllegalLabelDeclarationException(String.format("metric %s has an empty label name", metricName));
        }
    }

    public static interface Child {
        public void reset();
    }

    @NotThreadSafe
    public abstract class Partial {
        private final Map<String, String> dimensions = new HashMap<String, String>();

        protected Partial() {
        }

        public abstract P labelPair(String var1, String var2);

        P baseLabelPair(String labelName, String labelValue) {
            this.dimensions.put(labelName, labelValue);
            return this;
        }

        public P clone() {
            Object clone = Metric.this.newPartial();
            for (String name : this.dimensions.keySet()) {
                String value = this.dimensions.get(name);
                ((Partial)clone).labelPair(name, value);
            }
            return clone;
        }

        private Map<String, String> validate() {
            Map<String, String> ds = Collections.unmodifiableMap(this.dimensions);
            HashSet<String> claimed = new HashSet<String>();
            for (String k : ds.keySet()) {
                Preconditions.checkState((boolean)ds.containsKey(k), (Object)String.format("%s label dimension does not exist", k));
                Preconditions.checkState((!claimed.contains(k) ? 1 : 0) != 0, (Object)String.format("%s label dimension is already used", k));
                claimed.add(k);
            }
            return ds;
        }

        protected abstract C newChild();

        public abstract C apply();

        C baseApply() {
            TreeMap<String, String> t = new TreeMap<String, String>(this.validate());
            Child child = (Child)Metric.this.children.get(t);
            if (child == null) {
                child = this.newChild();
                Metric.this.children.put(t, child);
            }
            return child;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            try {
                Partial partial = (Partial)o;
                return this.dimensions.equals(partial.dimensions);
            }
            catch (ClassCastException unused) {
                return false;
            }
        }

        public int hashCode() {
            return this.dimensions.hashCode();
        }
    }

    static class BaseBuilder {
        private final boolean DEFAULT_REGISTER_STATIC = true;
        protected final Optional<String> namespace;
        protected final Optional<String> subsystem;
        protected final Optional<String> name;
        protected final Optional<String> d;
        protected final Optional<Boolean> registerStatic;
        protected final List<String> labelNames;

        BaseBuilder() {
            this.namespace = Optional.absent();
            this.subsystem = Optional.absent();
            this.name = Optional.absent();
            this.d = Optional.absent();
            this.registerStatic = Optional.absent();
            this.labelNames = new ArrayList<String>();
        }

        private BaseBuilder(Optional<String> namespace, Optional<String> subsystem, Optional<String> name, Optional<String> d, Optional<Boolean> registerStatic, List<String> labelNames) {
            this.namespace = namespace;
            this.subsystem = subsystem;
            this.name = name;
            this.d = d;
            this.registerStatic = registerStatic;
            this.labelNames = labelNames;
        }

        BaseBuilder namespace(String ns) {
            return new BaseBuilder((Optional<String>)Optional.of((Object)ns), this.subsystem, this.name, this.d, this.registerStatic, this.labelNames);
        }

        BaseBuilder subsystem(String ss) {
            return new BaseBuilder(this.namespace, (Optional<String>)Optional.of((Object)ss), this.name, this.d, this.registerStatic, this.labelNames);
        }

        BaseBuilder name(String n) {
            return new BaseBuilder(this.namespace, this.subsystem, (Optional<String>)Optional.of((Object)n), this.d, this.registerStatic, this.labelNames);
        }

        BaseBuilder documentation(String d) {
            return new BaseBuilder(this.namespace, this.subsystem, this.name, (Optional<String>)Optional.of((Object)d), this.registerStatic, this.labelNames);
        }

        BaseBuilder labelNames(String ... ds) {
            ArrayList<String> labels = new ArrayList<String>(this.labelNames);
            labels.addAll(Arrays.asList(ds));
            return new BaseBuilder(this.namespace, this.subsystem, this.name, this.d, this.registerStatic, labels);
        }

        BaseBuilder registerStatic(boolean rs) {
            return new BaseBuilder(this.namespace, this.subsystem, this.name, this.d, (Optional<Boolean>)Optional.of((Object)rs), this.labelNames);
        }

        boolean getRegisterStatic() {
            return (Boolean)this.registerStatic.or((Object)true);
        }

        String buildName() {
            Preconditions.checkArgument((boolean)this.name.isPresent(), (Object)"name may not be empty");
            if (!this.namespace.isPresent() && !this.subsystem.isPresent()) {
                return (String)this.name.get();
            }
            if (this.namespace.isPresent() && this.subsystem.isPresent()) {
                return String.format("%s_%s_%s", this.namespace.get(), this.subsystem.get(), this.name.get());
            }
            if (this.namespace.isPresent()) {
                return String.format("%s_%s", this.namespace.get(), this.name.get());
            }
            return String.format("%s_%s", this.subsystem.get(), this.name.get());
        }

        String buildDocstring() {
            Preconditions.checkArgument((boolean)this.d.isPresent(), (Object)"docstring may not be empty");
            return (String)this.d.get();
        }

        List<String> buildLabelNames() {
            String metricName = (String)this.name.or((Object)"<unknown>");
            for (String labelName : this.labelNames) {
                if (labelName.isEmpty()) {
                    throw IllegalLabelDeclarationException.empty(metricName);
                }
                if (!labelName.startsWith(Metric.PRIVATE_LABEL_NAMESPACE)) continue;
                throw IllegalLabelDeclarationException.reserved(labelName, metricName);
            }
            return this.labelNames;
        }
    }

    @ThreadSafe
    @Immutable
    public static interface Builder<B, M> {
        public B namespace(String var1);

        public B subsystem(String var1);

        public B name(String var1);

        public B documentation(String var1);

        public B labelNames(String ... var1);

        public B registerStatic(boolean var1);

        public M build();
    }
}

