/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client.metrics;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.AtomicDouble;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.matttproud.quantile.Estimator;
import com.matttproud.quantile.Quantile;
import io.prometheus.client.Metrics;
import io.prometheus.client.metrics.Metric;
import io.prometheus.client.utility.labels.Reserved;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class Summary
extends Metric<Summary, Child, Partial> {
    private final long purgeIntervalMs;
    private final Map<Double, Double> targets;
    Long lastPurgeInstantMs;

    private Summary(String n, String d, List<String> ds, long pi, Map<Double, Double> t, Metrics.MetricFamily p, boolean rs) {
        super(n, d, ds, p, rs);
        this.purgeIntervalMs = pi;
        this.targets = t;
        this.lastPurgeInstantMs = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void purge() {
        Long l = this.lastPurgeInstantMs;
        synchronized (l) {
            long now = System.currentTimeMillis();
            if (now - this.lastPurgeInstantMs < this.purgeIntervalMs) {
                return;
            }
            for (Child c : this.children.values()) {
                c.reset();
            }
            this.children.clear();
            this.lastPurgeInstantMs = now;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Metrics.MetricFamily.Builder annotateBuilder(Metrics.MetricFamily.Builder b) {
        try {
            for (Map labels : this.children.keySet()) {
                Child child = (Child)this.children.get(labels);
                Metrics.Metric.Builder m = b.addMetricBuilder();
                for (String label : labels.keySet()) {
                    String value = (String)labels.get(label);
                    m.addLabelBuilder().setName(label).setValue(value);
                }
                Metrics.Summary.Builder builder = Metrics.Summary.newBuilder();
                builder.setSampleCount(child.count.get());
                builder.setSampleSum(child.sum.get());
                Iterator i$ = child.targets.keySet().iterator();
                while (i$.hasNext()) {
                    double q = (Double)i$.next();
                    double v = child.query(q);
                    Metrics.Quantile.Builder qs = builder.addQuantileBuilder();
                    qs.setQuantile(q);
                    qs.setValue(v);
                }
                m.setSummary(builder.build());
            }
            Metrics.MetricFamily.Builder builder = b;
            return builder;
        }
        finally {
            this.purge();
        }
    }

    @Override
    public Partial newPartial() {
        return new Partial();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Serializer
    implements JsonSerializer<Summary> {
        public JsonElement serialize(Summary src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject container = new JsonObject();
            JsonObject baseLabels = new JsonObject();
            baseLabels.addProperty(Reserved.NAME.label(), src.name);
            container.add("baseLabels", (JsonElement)baseLabels);
            container.addProperty("docstring", src.docstring);
            JsonObject metric = new JsonObject();
            metric.addProperty("type", "histogram");
            JsonArray values = new JsonArray();
            for (Map labelSet : src.children.keySet()) {
                JsonObject element = new JsonObject();
                element.add("labels", context.serialize((Object)labelSet));
                Child vector = (Child)src.children.get(labelSet);
                JsonObject quantiles = new JsonObject();
                for (Double q : vector.targets.keySet()) {
                    double v = vector.query(q);
                    quantiles.addProperty(q.toString(), (Number)v);
                }
                element.add("value", (JsonElement)quantiles);
                values.add((JsonElement)element);
            }
            metric.add("value", (JsonElement)values);
            container.add("metric", context.serialize((Object)metric));
            return container;
        }
    }

    public class Child
    implements Metric.Child {
        private final AtomicDouble sum = new AtomicDouble();
        private final AtomicLong count = new AtomicLong();
        private final Map<Double, Double> targets;
        private Estimator<Double> estimator;

        Child(Map<Double, Double> targets) {
            this.targets = targets;
            Quantile[] quantiles = new Quantile[targets.size()];
            int i = 0;
            for (Double t : targets.keySet()) {
                Double a = targets.get(t);
                quantiles[i] = new Quantile(t.doubleValue(), a.doubleValue());
                ++i;
            }
            this.estimator = new Estimator(quantiles);
        }

        public synchronized void observe(Double v) {
            this.estimator.insert((Number)v);
            this.sum.getAndAdd(v.doubleValue());
            this.count.getAndIncrement();
        }

        @Override
        public synchronized void reset() {
            Quantile[] quantiles = new Quantile[this.targets.size()];
            int i = 0;
            for (Double t : this.targets.keySet()) {
                Double a = this.targets.get(t);
                quantiles[i] = new Quantile(t.doubleValue(), a.doubleValue());
                ++i;
            }
            this.estimator = new Estimator(quantiles);
            this.sum.set(0.0);
            this.count.set(0L);
        }

        synchronized Double query(Double q) {
            return (Double)this.estimator.query(q.doubleValue());
        }
    }

    public class Partial
    extends Metric.Partial {
        public Partial labelPair(String labelName, String labelValue) {
            return (Partial)this.baseLabelPair(labelName, labelValue);
        }

        protected Child newChild() {
            return new Child(Summary.this.targets);
        }

        public Child apply() {
            return (Child)this.baseApply();
        }
    }

    public static class Builder
    implements Metric.Builder<Builder, Summary> {
        private static final Long DEFAULT_PURGE_INTERVAL = TimeUnit.MINUTES.toMillis(15L);
        private static final ImmutableMap<Double, Double> DEFAULT_TARGETS = ImmutableMap.of((Object)0.5, (Object)0.05, (Object)0.9, (Object)0.01, (Object)0.99, (Object)0.001);
        private final Metric.BaseBuilder base;
        private final Map<Double, Double> targets;
        private final Optional<Long> purgeIntervalMs;

        Builder() {
            this.base = new Metric.BaseBuilder();
            this.targets = new HashMap<Double, Double>();
            this.purgeIntervalMs = Optional.absent();
        }

        private Builder(Metric.BaseBuilder base, Map<Double, Double> targets, Optional<Long> purgeIntervalMs) {
            this.base = base;
            this.targets = targets;
            this.purgeIntervalMs = purgeIntervalMs;
        }

        @Override
        public Builder labelNames(String ... ds) {
            return new Builder(this.base.labelNames(ds), this.targets, this.purgeIntervalMs);
        }

        @Override
        public Builder documentation(String d) {
            return new Builder(this.base.documentation(d), this.targets, this.purgeIntervalMs);
        }

        @Override
        public Builder name(String n) {
            return new Builder(this.base.name(n), this.targets, this.purgeIntervalMs);
        }

        @Override
        public Builder subsystem(String ss) {
            return new Builder(this.base.subsystem(ss), this.targets, this.purgeIntervalMs);
        }

        @Override
        public Builder namespace(String ns) {
            return new Builder(this.base.namespace(ns), this.targets, this.purgeIntervalMs);
        }

        @Override
        public Builder registerStatic(boolean rs) {
            return new Builder(this.base.registerStatic(rs), this.targets, this.purgeIntervalMs);
        }

        public Builder purgeInterval(int n, TimeUnit u) {
            return new Builder(this.base, this.targets, (Optional<Long>)Optional.of((Object)u.toMillis(n)));
        }

        public Builder targetQuantile(Double quantile, Double inaccuracy) {
            HashMap<Double, Double> quantiles = new HashMap<Double, Double>(this.targets);
            quantiles.put(quantile, inaccuracy);
            return new Builder(this.base, quantiles, this.purgeIntervalMs);
        }

        private long getPurgeIntervalMs() {
            return (Long)this.purgeIntervalMs.or((Object)DEFAULT_PURGE_INTERVAL);
        }

        private Map<Double, Double> getTargets() {
            if (this.targets.size() == 0) {
                return DEFAULT_TARGETS;
            }
            return this.targets;
        }

        @Override
        public Summary build() {
            String name = this.base.buildName();
            String docstring = this.base.buildDocstring();
            Metrics.MetricFamily.Builder builder = Metrics.MetricFamily.newBuilder().setName(name).setHelp(docstring).setType(Metrics.MetricType.SUMMARY);
            return new Summary(this.base.buildName(), this.base.buildDocstring(), this.base.buildLabelNames(), this.getPurgeIntervalMs(), this.getTargets(), builder.build(), this.base.getRegisterStatic());
        }
    }
}

