/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client.metrics;

import com.google.common.base.Optional;
import com.google.common.util.concurrent.AtomicDouble;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.prometheus.client.Metrics;
import io.prometheus.client.metrics.Metric;
import io.prometheus.client.utility.labels.Reserved;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class Gauge
extends Metric<Gauge, Child, Partial> {
    private final double defaultValue;

    private Gauge(String n, String d, List<String> ds, double defaultValue, Metrics.MetricFamily p, boolean rs) {
        super(n, d, ds, p, rs);
        this.defaultValue = defaultValue;
    }

    @Override
    Metrics.MetricFamily.Builder annotateBuilder(Metrics.MetricFamily.Builder b) {
        for (Map labels : this.children.keySet()) {
            Child child = (Child)this.children.get(labels);
            Metrics.Metric.Builder m = b.addMetricBuilder();
            for (String label : labels.keySet()) {
                String value = (String)labels.get(label);
                m.addLabelBuilder().setName(label).setValue(value);
            }
            m.setGauge(Metrics.Gauge.newBuilder().setValue(child.value.get()));
        }
        return b;
    }

    @Override
    public Partial newPartial() {
        return new Partial();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Gauge)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Gauge gauge = (Gauge)o;
        return Double.compare(gauge.defaultValue, this.defaultValue) == 0;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.defaultValue);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public static class Serializer
    implements JsonSerializer<Gauge> {
        public JsonElement serialize(Gauge src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject container = new JsonObject();
            JsonObject baseLabels = new JsonObject();
            baseLabels.addProperty(Reserved.NAME.label(), src.name);
            container.add("baseLabels", (JsonElement)baseLabels);
            container.addProperty("docstring", src.docstring);
            JsonObject metric = new JsonObject();
            metric.addProperty("type", "gauge");
            JsonArray values = new JsonArray();
            for (Map labelSet : src.children.keySet()) {
                JsonObject element = new JsonObject();
                element.add("labels", context.serialize((Object)labelSet));
                Child vector = (Child)src.children.get(labelSet);
                element.add("value", context.serialize((Object)vector.value.get()));
                values.add((JsonElement)element);
            }
            metric.add("value", (JsonElement)values);
            container.add("metric", context.serialize((Object)metric));
            return container;
        }
    }

    public class Child
    implements Metric.Child {
        final AtomicDouble value = new AtomicDouble();

        public void set(double v) {
            this.value.getAndSet(v);
        }

        @Override
        public void reset() {
            this.value.getAndSet(Gauge.this.defaultValue);
        }
    }

    public class Partial
    extends Metric.Partial {
        public Partial() {
            super(Gauge.this);
        }

        public Partial labelPair(String labelName, String labelValue) {
            return (Partial)this.baseLabelPair(labelName, labelValue);
        }

        protected Child newChild() {
            return new Child();
        }

        public Child apply() {
            return (Child)this.baseApply();
        }
    }

    public static class Builder
    implements Metric.Builder<Builder, Gauge> {
        private static final Double DEFAULT_VALUE = 0.0;
        private final Metric.BaseBuilder base;
        private final Optional<Double> defaultValue;

        Builder() {
            this.base = new Metric.BaseBuilder();
            this.defaultValue = Optional.absent();
        }

        private Builder(Metric.BaseBuilder base, Optional<Double> defaultValue) {
            this.base = base;
            this.defaultValue = defaultValue;
        }

        @Override
        public Builder labelNames(String ... ds) {
            return new Builder(this.base.labelNames(ds), this.defaultValue);
        }

        @Override
        public Builder documentation(String d) {
            return new Builder(this.base.documentation(d), this.defaultValue);
        }

        @Override
        public Builder name(String n) {
            return new Builder(this.base.name(n), this.defaultValue);
        }

        @Override
        public Builder subsystem(String ss) {
            return new Builder(this.base.subsystem(ss), this.defaultValue);
        }

        @Override
        public Builder namespace(String ns) {
            return new Builder(this.base.namespace(ns), this.defaultValue);
        }

        @Override
        public Builder registerStatic(boolean rs) {
            return new Builder(this.base.registerStatic(rs), this.defaultValue);
        }

        public Builder defaultValue(Double v) {
            return new Builder(this.base, (Optional<Double>)Optional.of((Object)v));
        }

        private double getDefaultValue() {
            return (Double)this.defaultValue.or((Object)DEFAULT_VALUE);
        }

        @Override
        public Gauge build() {
            String name = this.base.buildName();
            String docstring = this.base.buildDocstring();
            Metrics.MetricFamily.Builder builder = Metrics.MetricFamily.newBuilder().setName(name).setHelp(docstring).setType(Metrics.MetricType.GAUGE);
            return new Gauge(this.base.buildName(), this.base.buildDocstring(), this.base.buildLabelNames(), this.getDefaultValue(), builder.build(), this.base.getRegisterStatic());
        }
    }
}

