/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client;

import com.google.common.util.concurrent.AtomicDouble;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import io.prometheus.client.AtomicDoubleSerializer;
import io.prometheus.client.Register;
import io.prometheus.client.Telemetry;
import io.prometheus.client.metrics.Counter;
import io.prometheus.client.metrics.Gauge;
import io.prometheus.client.metrics.Metric;
import io.prometheus.client.metrics.Summary;
import io.prometheus.client.utility.Clock;
import io.prometheus.client.utility.SystemClock;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.FieldAnnotationsScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;

public class Prometheus {
    private static final Logger log = Logger.getLogger(Prometheus.class.getName());
    private static final Gson serializer = new GsonBuilder().registerTypeAdapter(AtomicDouble.class, (Object)new AtomicDoubleSerializer()).registerTypeAdapter(Counter.class, (Object)new Counter.Serializer()).registerTypeAdapter(Gauge.class, (Object)new Gauge.Serializer()).registerTypeAdapter(Summary.class, (Object)new Summary.Serializer()).create();
    private static final Prometheus defaultPrometheus = new Prometheus();
    private final Clock clock = new SystemClock();
    private final ConcurrentHashMap<Metric, Metric> metrics = new ConcurrentHashMap();
    private final ConcurrentHashMap<ExpositionHook, Object> preexpositionHooks = new ConcurrentHashMap();

    private void register(Metric m) {
        Metric existing = this.metrics.putIfAbsent(m, m);
        if (existing == null) {
            log.log(Level.FINE, String.format("Registered %s", m));
        } else if (existing != m) {
            log.log(Level.WARNING, String.format("Cannot register %s, because %s is registered in its place.", m, existing));
        }
    }

    private void dumpProto(OutputStream o) throws IOException {
        long start = this.clock.nowMs();
        this.runPreexpositionHooks();
        Counter.Partial requests = Telemetry.telemetryRequests.newPartial();
        Summary.Partial latencies = Telemetry.telemetryGenerationLatencies.newPartial();
        try {
            for (Metric m : this.metrics.keySet()) {
                m.dump().writeDelimitedTo(o);
            }
            requests.labelPair("result", "success");
            latencies.labelPair("result", "success");
        }
        catch (IOException e) {
            requests.labelPair("result", "failure");
            latencies.labelPair("result", "failure");
            throw e;
        }
        catch (RuntimeException e) {
            requests.labelPair("result", "failure");
            latencies.labelPair("result", "failure");
            throw e;
        }
        finally {
            double duration = this.clock.nowMs() - start;
            requests.apply().increment();
            latencies.apply().observe(duration);
        }
    }

    private void dumpJson(Writer writer) throws IOException {
        long start = this.clock.nowMs();
        this.runPreexpositionHooks();
        Counter.Partial requests = Telemetry.telemetryRequests.newPartial();
        Summary.Partial latencies = Telemetry.telemetryGenerationLatencies.newPartial();
        try {
            JsonArray array = new JsonArray();
            for (Metric m : this.metrics.keySet()) {
                array.add(serializer.toJsonTree((Object)m));
            }
            writer.write(array.toString());
            requests.labelPair("result", "success");
            latencies.labelPair("result", "success");
        }
        catch (IOException e) {
            requests.labelPair("result", "failure");
            latencies.labelPair("result", "failure");
            throw e;
        }
        catch (RuntimeException e) {
            requests.labelPair("result", "failure");
            latencies.labelPair("result", "failure");
            throw e;
        }
        finally {
            double duration = this.clock.nowMs() - start;
            requests.apply().increment();
            latencies.apply().observe(duration);
        }
    }

    public static void defaultRegister(Metric m) {
        defaultPrometheus.register(m);
    }

    public static void defaultDumpJson(Writer writer) throws IOException {
        defaultPrometheus.dumpJson(writer);
    }

    public static void defaultDumpProto(OutputStream o) throws IOException {
        defaultPrometheus.dumpProto(o);
    }

    private Collection<Field> collectAnnotatedFields() {
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls((Collection)ClasspathHelper.forJavaClassPath()).setScanners(new Scanner[]{new FieldAnnotationsScanner()}));
        return reflections.getFieldsAnnotatedWith(Register.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        long start = this.clock.nowMs();
        Gauge.Partial duration = Telemetry.initializeTime.newPartial();
        try {
            Collection<Field> fields = this.collectAnnotatedFields();
            for (Field field : fields) {
                boolean wasAccessible = field.isAccessible();
                String candidateName = field.getDeclaringClass().getCanonicalName();
                try {
                    Register annotation;
                    Class<?> klass = Class.forName(candidateName);
                    if (klass == null || (annotation = field.getAnnotation(Register.class)) == null) continue;
                    if (!wasAccessible) {
                        field.setAccessible(true);
                    }
                    Metric metric = (Metric)field.get(klass);
                    this.register(metric);
                }
                catch (ClassNotFoundException e) {
                    System.err.printf("Could not find %s\n", candidateName);
                }
                catch (IllegalAccessException e) {
                    System.err.printf("Not allowed to access %s\n", field);
                }
                finally {
                    if (wasAccessible) continue;
                    field.setAccessible(false);
                }
            }
            duration.labelPair("result", "success");
        }
        catch (RuntimeException e) {
            duration.labelPair("result", "failure");
            throw e;
        }
        finally {
            float elapsed = this.clock.nowMs() - start;
            duration.apply().set(elapsed);
        }
    }

    private void addPreexpositionHook(ExpositionHook h) {
        this.preexpositionHooks.putIfAbsent(h, new Object());
    }

    private void runPreexpositionHooks() {
        for (ExpositionHook hook : this.preexpositionHooks.keySet()) {
            hook.run();
        }
    }

    public static void defaultInitialize() {
        defaultPrometheus.initialize();
    }

    public static void defaultAddPreexpositionHook(ExpositionHook h) {
        defaultPrometheus.addPreexpositionHook(h);
    }

    public static interface ExpositionHook
    extends Runnable {
    }
}

