/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client.metrics;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.AtomicDouble;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.matttproud.quantile.Estimator;
import com.matttproud.quantile.Quantile;
import io.prometheus.client.Metrics;
import io.prometheus.client.metrics.Metric;
import io.prometheus.client.utility.labels.Reserved;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.ThreadSafe;
import org.joda.time.Instant;
import org.joda.time.Minutes;
import org.joda.time.ReadableDuration;

@ThreadSafe
public class Summary
extends Metric<Summary, Child, Partial> {
    private final int purgeInterval;
    private final ReadableDuration purgeTimeUnit;
    private final ImmutableMap<Double, Double> targets;
    private Instant lastPurge;

    private Summary(String n, String d, ImmutableList<String> ds, int pi, ReadableDuration pu, ImmutableMap<Double, Double> t, Metrics.MetricFamily p) {
        super(n, d, ds, p);
        this.purgeInterval = pi;
        this.purgeTimeUnit = pu;
        this.targets = t;
        this.lastPurge = Instant.now();
    }

    void purge() {
        if (this.lastPurge.withDurationAdded(this.purgeTimeUnit, this.purgeInterval).isAfterNow()) {
            return;
        }
        for (Child c : this.children.values()) {
            c.reset();
        }
        this.children.clear();
        this.lastPurge = Instant.now();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Metrics.MetricFamily.Builder annotateBuilder(Metrics.MetricFamily.Builder b) {
        try {
            for (Map labels : this.children.keySet()) {
                Child child = (Child)this.children.get(labels);
                Metrics.Metric.Builder m = b.addMetricBuilder();
                for (String label : labels.keySet()) {
                    String value = (String)labels.get(label);
                    m.addLabelBuilder().setName(label).setValue(value);
                }
                Metrics.Summary.Builder builder = Metrics.Summary.newBuilder();
                for (Child c : this.children.values()) {
                    builder.setSampleCount(c.count.get());
                    builder.setSampleSum(c.sum.get());
                    Iterator i$ = c.targets.keySet().iterator();
                    while (i$.hasNext()) {
                        double q = (Double)i$.next();
                        double v = c.query(q);
                        Metrics.Quantile.Builder qs = builder.addQuantileBuilder();
                        qs.setQuantile(q);
                        qs.setValue(v);
                    }
                }
                m.setSummary(builder.build());
            }
            Metrics.MetricFamily.Builder builder = b;
            return builder;
        }
        finally {
            this.purge();
        }
    }

    @Override
    public Partial newPartial() {
        return new Partial();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Summary)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Summary summary = (Summary)o;
        if (this.purgeInterval != summary.purgeInterval) {
            return false;
        }
        if (!this.purgeTimeUnit.equals(summary.purgeTimeUnit)) {
            return false;
        }
        return this.targets.equals(summary.targets);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.purgeInterval;
        result = 31 * result + this.purgeTimeUnit.hashCode();
        result = 31 * result + this.targets.hashCode();
        return result;
    }

    public static class Serializer
    implements JsonSerializer<Summary> {
        public JsonElement serialize(Summary src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject container = new JsonObject();
            JsonObject baseLabels = new JsonObject();
            baseLabels.addProperty(Reserved.NAME.label(), src.name);
            container.add("baseLabels", (JsonElement)baseLabels);
            container.addProperty("docstring", src.docstring);
            JsonObject metric = new JsonObject();
            metric.addProperty("type", "histogram");
            JsonArray values = new JsonArray();
            for (Map labelSet : src.children.keySet()) {
                JsonObject element = new JsonObject();
                element.add("labels", context.serialize((Object)labelSet));
                Child vector = (Child)src.children.get(labelSet);
                JsonObject quantiles = new JsonObject();
                for (Double q : vector.targets.keySet()) {
                    double v = vector.query(q);
                    quantiles.addProperty(q.toString(), (Number)v);
                }
                element.add("value", (JsonElement)quantiles);
                values.add((JsonElement)element);
            }
            metric.add("value", (JsonElement)values);
            container.add("metric", context.serialize((Object)metric));
            return container;
        }
    }

    public class Child
    implements Metric.Child {
        private final AtomicDouble sum = new AtomicDouble();
        private final AtomicLong count = new AtomicLong();
        private final ImmutableMap<Double, Double> targets;
        private Estimator<Double> estimator;

        Child(ImmutableMap<Double, Double> targets) {
            this.targets = targets;
            Quantile[] quantiles = new Quantile[targets.size()];
            int i = 0;
            for (Double t : targets.keySet()) {
                Double a = (Double)targets.get((Object)t);
                quantiles[i] = new Quantile(t.doubleValue(), a.doubleValue());
                ++i;
            }
            this.estimator = new Estimator(quantiles);
        }

        public synchronized void observe(Double v) {
            this.estimator.insert((Number)v);
            this.sum.getAndAdd(v.doubleValue());
            this.count.getAndIncrement();
        }

        @Override
        public synchronized void reset() {
            Quantile[] quantiles = new Quantile[this.targets.size()];
            int i = 0;
            for (Double t : this.targets.keySet()) {
                Double a = (Double)this.targets.get((Object)t);
                quantiles[i] = new Quantile(t.doubleValue(), a.doubleValue());
                ++i;
            }
            this.estimator = new Estimator(quantiles);
            this.sum.set(0.0);
            this.count.set(0L);
        }

        synchronized Double query(Double q) {
            return (Double)this.estimator.query(q.doubleValue());
        }
    }

    public class Partial
    extends Metric.Partial {
        public Partial withDimension(String labelName, String labelValue) {
            return (Partial)this.baseWithDimension(labelName, labelValue);
        }

        protected Child newChild() {
            return new Child((ImmutableMap<Double, Double>)Summary.this.targets);
        }

        public Child apply() {
            return (Child)this.baseApply();
        }
    }

    public static class Builder {
        private static final ReadableDuration DEFAULT_PURGE_TIME_UNIT = Minutes.ONE.toStandardDuration();
        private static final Integer DEFAULT_PURGE_INTERVAL = 15;
        private static final ImmutableMap<Double, Double> DEFAULT_TARGETS = ImmutableMap.of((Object)0.5, (Object)0.05, (Object)0.99, (Object)0.001);
        private final Metric.BaseBuilder base = new Metric.BaseBuilder();
        private final ImmutableMap.Builder<Double, Double> targets = ImmutableMap.builder();
        private Optional<ReadableDuration> purgeTimeUnit = Optional.absent();
        private Optional<Integer> purgeInterval = Optional.absent();

        public Builder withDimension(String ... ds) {
            this.base.withDimension(ds);
            return this;
        }

        public Builder documentedAs(String d) {
            this.base.documentedAs(d);
            return this;
        }

        public Builder named(String n) {
            this.base.named(n);
            return this;
        }

        public Builder ofSubsystem(String ss) {
            this.base.ofSubsystem(ss);
            return this;
        }

        public Builder inNamespace(String ns) {
            this.base.inNamespace(ns);
            return this;
        }

        public Builder purgesEvery(int n, ReadableDuration d) {
            this.purgeTimeUnit = Optional.of((Object)d);
            this.purgeInterval = Optional.of((Object)n);
            return this;
        }

        public Builder withTarget(Double quantile, Double inaccuracy) {
            this.targets.put((Object)quantile, (Object)inaccuracy);
            return this;
        }

        private ReadableDuration getPurgeTimeUnit() {
            return (ReadableDuration)this.purgeTimeUnit.or((Object)DEFAULT_PURGE_TIME_UNIT);
        }

        private int getPurgeInterval() {
            return (Integer)this.purgeInterval.or((Object)DEFAULT_PURGE_INTERVAL);
        }

        private ImmutableMap<Double, Double> getTargets() {
            ImmutableMap setTargets = this.targets.build();
            if (setTargets.size() == 0) {
                return DEFAULT_TARGETS;
            }
            return setTargets;
        }

        public Summary build() {
            String name = this.base.buildName();
            String docstring = this.base.buildDocstring();
            Metrics.MetricFamily.Builder builder = Metrics.MetricFamily.newBuilder().setName(name).setHelp(docstring).setType(Metrics.MetricType.SUMMARY);
            return new Summary(this.base.buildName(), this.base.buildDocstring(), this.base.buildDimensions(), this.getPurgeInterval(), this.getPurgeTimeUnit(), this.getTargets(), builder.build());
        }
    }
}

