/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client.metrics;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prometheus.client.Metrics;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;

public abstract class Metric<M extends Metric, C extends Child, P extends Partial> {
    static final String SERIALIZE_BASE_LABELS = "baseLabels";
    static final String SERIALIZE_DOCSTRING = "docstring";
    static final String SERIALIZE_METRIC = "metric";
    private final ImmutableList<String> dimensions;
    private final Metrics.MetricFamily partial;
    final String name;
    final String docstring;
    final ConcurrentHashMap<Map<String, String>, C> children = new ConcurrentHashMap();

    protected Metric(String n, String d, ImmutableList<String> ds, Metrics.MetricFamily p) {
        this.name = n;
        this.docstring = d;
        this.dimensions = ds;
        this.partial = p;
    }

    Metrics.MetricFamily.Builder getPartialBuilder() {
        return Metrics.MetricFamily.newBuilder((Metrics.MetricFamily)this.partial);
    }

    abstract Metrics.MetricFamily.Builder annotateBuilder(Metrics.MetricFamily.Builder var1);

    public Metrics.MetricFamily dump() {
        return this.annotateBuilder(this.getPartialBuilder()).build();
    }

    public void resetAll() {
        Iterator<C> i$ = this.children.values().iterator();
        while (i$.hasNext()) {
            Child child;
            Child cast = child = (Child)i$.next();
            cast.reset();
        }
    }

    public void disbandChildren() {
        this.children.clear();
    }

    public abstract P newPartial();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Metric)) {
            return false;
        }
        Metric metric = (Metric)o;
        if (!this.dimensions.equals(metric.dimensions)) {
            return false;
        }
        if (!this.docstring.equals(metric.docstring)) {
            return false;
        }
        return this.name.equals(metric.name);
    }

    public int hashCode() {
        int result = this.dimensions.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.docstring.hashCode();
        return result;
    }

    public static interface Child {
        public void reset();
    }

    public abstract class Partial<D extends Child> {
        private final ImmutableMap.Builder<String, String> dimensions = ImmutableMap.builder();

        protected Partial() {
        }

        public abstract P withDimension(String var1, String var2);

        P baseWithDimension(String labelName, String labelValue) {
            this.dimensions.put((Object)labelName, (Object)labelValue);
            return this;
        }

        private ImmutableMap<String, String> validate() {
            ImmutableMap ds = this.dimensions.build();
            HashSet<String> claimed = new HashSet<String>();
            for (String k : ds.keySet()) {
                Preconditions.checkState((boolean)ds.containsKey((Object)k), (Object)String.format("%s label dimension does not exist", k));
                Preconditions.checkState((!claimed.contains(k) ? 1 : 0) != 0, (Object)String.format("%s label dimension is already used", k));
                claimed.add(k);
            }
            return ds;
        }

        protected abstract C newChild();

        public abstract C apply();

        C baseApply() {
            TreeMap<String, String> t = new TreeMap<String, String>((Map<String, String>)this.validate());
            Child v = (Child)Metric.this.children.putIfAbsent(t, this.newChild());
            if (v != null) {
                return v;
            }
            return (Child)Metric.this.children.get(t);
        }
    }

    public static class BaseBuilder {
        protected Optional<String> ns = Optional.absent();
        protected Optional<String> ss = Optional.absent();
        protected Optional<String> n = Optional.absent();
        protected Optional<String> d = Optional.absent();
        protected final ImmutableList.Builder<String> ds = ImmutableList.builder();

        BaseBuilder() {
        }

        public BaseBuilder inNamespace(String ns) {
            this.ns = Optional.of((Object)ns);
            return this;
        }

        public BaseBuilder ofSubsystem(String ss) {
            this.ss = Optional.of((Object)ss);
            return this;
        }

        public BaseBuilder named(String n) {
            this.n = Optional.of((Object)n);
            return this;
        }

        public BaseBuilder documentedAs(String d) {
            this.d = Optional.of((Object)d);
            return this;
        }

        public BaseBuilder withDimension(String ... ds) {
            this.ds.add((Object[])ds);
            return this;
        }

        String buildName() {
            Preconditions.checkArgument((boolean)this.n.isPresent(), (Object)"name may not be empty");
            if (!this.ns.isPresent() && !this.ss.isPresent()) {
                return (String)this.n.get();
            }
            if (this.ns.isPresent() && this.ss.isPresent()) {
                return String.format("%s_%s_%s", this.ns.get(), this.ss.get(), this.n.get());
            }
            if (this.ns.isPresent()) {
                return String.format("%s_%s", this.ns.get(), this.n.get());
            }
            return String.format("%s_%s", this.ss.get(), this.n.get());
        }

        String buildDocstring() {
            Preconditions.checkArgument((boolean)this.d.isPresent(), (Object)"docstring may not be empty");
            return (String)this.d.get();
        }

        ImmutableList<String> buildDimensions() {
            return this.ds.build();
        }
    }
}

