/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client.metrics;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.AtomicDouble;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.prometheus.client.Metrics;
import io.prometheus.client.metrics.Metric;
import io.prometheus.client.utility.labels.Reserved;
import java.lang.reflect.Type;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class Gauge
extends Metric<Gauge, Child, Partial> {
    private final double defaultValue;

    private Gauge(String n, String d, ImmutableList<String> ds, double defaultValue, Metrics.MetricFamily p) {
        super(n, d, ds, p);
        this.defaultValue = defaultValue;
    }

    @Override
    Metrics.MetricFamily.Builder annotateBuilder(Metrics.MetricFamily.Builder b) {
        for (Map labels : this.children.keySet()) {
            Child child = (Child)this.children.get(labels);
            Metrics.Metric.Builder m = b.addMetricBuilder();
            for (String label : labels.keySet()) {
                String value = (String)labels.get(label);
                m.addLabelBuilder().setName(label).setValue(value);
            }
            m.setGauge(Metrics.Gauge.newBuilder().setValue(child.value.get()));
        }
        return b;
    }

    @Override
    public Partial newPartial() {
        return new Partial();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Gauge)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Gauge gauge = (Gauge)o;
        return Double.compare(gauge.defaultValue, this.defaultValue) == 0;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.defaultValue);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public static class Serializer
    implements JsonSerializer<Gauge> {
        public JsonElement serialize(Gauge src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject container = new JsonObject();
            JsonObject baseLabels = new JsonObject();
            baseLabels.addProperty(Reserved.NAME.label(), src.name);
            container.add("baseLabels", (JsonElement)baseLabels);
            container.addProperty("docstring", src.docstring);
            JsonObject metric = new JsonObject();
            metric.addProperty("type", "gauge");
            JsonArray values = new JsonArray();
            for (Map labelSet : src.children.keySet()) {
                JsonObject element = new JsonObject();
                element.add("labels", context.serialize((Object)labelSet));
                Child vector = (Child)src.children.get(labelSet);
                element.add("value", context.serialize((Object)vector.value.get()));
                values.add((JsonElement)element);
            }
            metric.add("value", (JsonElement)values);
            container.add("metric", context.serialize((Object)metric));
            return container;
        }
    }

    public class Child
    implements Metric.Child {
        private final AtomicDouble value = new AtomicDouble();

        public void set(double v) {
            this.value.getAndSet(v);
        }

        @Override
        public void reset() {
            this.value.getAndSet(Gauge.this.defaultValue);
        }
    }

    public class Partial
    extends Metric.Partial {
        public Partial() {
            super(Gauge.this);
        }

        public Partial withDimension(String labelName, String labelValue) {
            return (Partial)this.baseWithDimension(labelName, labelValue);
        }

        protected Child newChild() {
            return new Child();
        }

        public Child apply() {
            return (Child)this.baseApply();
        }
    }

    public static class Builder {
        private static final Double DEFAULT_VALUE = 0.0;
        private final Metric.BaseBuilder base = new Metric.BaseBuilder();
        private Optional<Double> defaultValue = Optional.absent();

        public Builder withDimension(String ... ds) {
            this.base.withDimension(ds);
            return this;
        }

        public Builder documentedAs(String d) {
            this.base.documentedAs(d);
            return this;
        }

        public Builder named(String n) {
            this.base.named(n);
            return this;
        }

        public Builder ofSubsystem(String ss) {
            this.base.ofSubsystem(ss);
            return this;
        }

        public Builder inNamespace(String ns) {
            this.base.inNamespace(ns);
            return this;
        }

        public Builder withDefaultValue(Double v) {
            this.defaultValue = Optional.of((Object)v);
            return this;
        }

        private double getDefaultValue() {
            return (Double)this.defaultValue.or((Object)DEFAULT_VALUE);
        }

        public Gauge build() {
            String name = this.base.buildName();
            String docstring = this.base.buildDocstring();
            Metrics.MetricFamily.Builder builder = Metrics.MetricFamily.newBuilder().setName(name).setHelp(docstring).setType(Metrics.MetricType.GAUGE);
            return new Gauge(this.base.buildName(), this.base.buildDocstring(), this.base.buildDimensions(), this.getDefaultValue(), builder.build());
        }
    }
}

