/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client;

import com.google.common.util.concurrent.AtomicDouble;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import io.prometheus.client.Register;
import io.prometheus.client.Telemetry;
import io.prometheus.client.metrics.AtomicDoubleSerializer;
import io.prometheus.client.metrics.Counter;
import io.prometheus.client.metrics.Gauge;
import io.prometheus.client.metrics.Metric;
import io.prometheus.client.metrics.Summary;
import io.prometheus.client.utility.Clock;
import io.prometheus.client.utility.SystemClock;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import org.joda.time.Instant;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.FieldAnnotationsScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Prometheus {
    private static final Logger log = LoggerFactory.getLogger(Prometheus.class);
    private static final Gson serializer = new GsonBuilder().registerTypeAdapter(AtomicDouble.class, (Object)new AtomicDoubleSerializer()).registerTypeAdapter(Counter.class, (Object)new Counter.Serializer()).registerTypeAdapter(Gauge.class, (Object)new Gauge.Serializer()).registerTypeAdapter(Summary.class, (Object)new Summary.Serializer()).create();
    private static final Prometheus defaultPrometheus = new Prometheus();
    private final ConcurrentHashMap<Metric, Instant> metrics = new ConcurrentHashMap();
    private final Clock clock = new SystemClock();

    private void register(Metric m) {
        if (this.metrics.putIfAbsent(m, this.clock.now()) != null) {
            log.warn(String.format("Metric %s is already registered!", m));
        }
    }

    private void dumpProto(OutputStream o) throws IOException {
        Instant start = this.clock.now();
        Counter.Partial requests = Telemetry.telemetryRequests.newPartial();
        Summary.Partial latencies = Telemetry.telemetryGenerationLatencies.newPartial();
        try {
            for (Metric m : this.metrics.keySet()) {
                m.dump().writeDelimitedTo(o);
            }
            requests.withDimension("result", "success");
            latencies.withDimension("result", "success");
        }
        catch (IOException e) {
            requests.withDimension("result", "failure");
            latencies.withDimension("result", "failure");
            throw e;
        }
        catch (RuntimeException e) {
            requests.withDimension("result", "failure");
            latencies.withDimension("result", "failure");
            throw e;
        }
        finally {
            double duration = this.clock.now().getMillis() - start.getMillis();
            requests.apply().increment();
            latencies.apply().observe(duration);
        }
    }

    private void dumpJson(Writer writer) throws IOException {
        Instant start = this.clock.now();
        Counter.Partial requests = Telemetry.telemetryRequests.newPartial();
        Summary.Partial latencies = Telemetry.telemetryGenerationLatencies.newPartial();
        try {
            JsonArray array = new JsonArray();
            for (Metric m : this.metrics.keySet()) {
                array.add(serializer.toJsonTree((Object)m));
            }
            writer.write(array.toString());
            requests.withDimension("result", "success");
            latencies.withDimension("result", "success");
        }
        catch (IOException e) {
            requests.withDimension("result", "failure");
            latencies.withDimension("result", "failure");
            throw e;
        }
        catch (RuntimeException e) {
            requests.withDimension("result", "failure");
            latencies.withDimension("result", "failure");
            throw e;
        }
        finally {
            double duration = this.clock.now().getMillis() - start.getMillis();
            requests.apply().increment();
            latencies.apply().observe(duration);
        }
    }

    private static void defaultRegister(Metric m) {
        defaultPrometheus.register(m);
    }

    public static void defaultDumpJson(Writer writer) throws IOException {
        defaultPrometheus.dumpJson(writer);
    }

    public static void defaultDumpProto(OutputStream o) throws IOException {
        defaultPrometheus.dumpProto(o);
    }

    private Collection<Field> collectAnnotatedFields() {
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls((Collection)ClasspathHelper.forJavaClassPath()).setScanners(new Scanner[]{new FieldAnnotationsScanner()}));
        return reflections.getFieldsAnnotatedWith(Register.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        Instant start = this.clock.now();
        Gauge.Partial duration = Telemetry.telemetryInitializationTime.newPartial();
        try {
            Collection<Field> fields = this.collectAnnotatedFields();
            for (Field field : fields) {
                boolean wasAccessible = field.isAccessible();
                String candidateName = field.getDeclaringClass().getCanonicalName();
                try {
                    Register annotation;
                    Class<?> klass = Class.forName(candidateName);
                    if (klass == null || (annotation = field.getAnnotation(Register.class)) == null) continue;
                    if (!wasAccessible) {
                        field.setAccessible(true);
                    }
                    Metric metric = (Metric)field.get(klass);
                    this.register(metric);
                }
                catch (ClassNotFoundException e) {
                    System.err.printf("Could not find %s\n", candidateName);
                }
                catch (IllegalAccessException e) {
                    System.err.printf("Not allowed to access %s\n", field);
                }
                finally {
                    if (wasAccessible) continue;
                    field.setAccessible(false);
                }
            }
            duration.withDimension("result", "success");
        }
        catch (RuntimeException e) {
            duration.withDimension("result", "failure");
            throw e;
        }
        finally {
            float elapsed = this.clock.now().getMillis() - start.getMillis();
            duration.apply().set(elapsed);
        }
    }

    public static void defaultInitialize() {
        defaultPrometheus.initialize();
    }
}

