/*
 * Decompiled with CFR 0.152.
 */
package io.progix.jackson;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.progix.jackson.exceptions.JsonPatchFormatException;

public class JsonPatchUtil {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JsonNode remove(JsonPointer pathPointer, JsonNode rootNode) throws JsonPatchFormatException {
        rootNode = rootNode.deepCopy();
        JsonPointer lastPointer = pathPointer.last();
        JsonPointer parentPointer = pathPointer.head();
        if (parentPointer == null) {
            ((ObjectNode)rootNode).removeAll();
            return rootNode;
        }
        JsonNode parentTargetNode = rootNode.at(parentPointer);
        if (parentTargetNode.isArray()) {
            ArrayNode arrayTargetNode = (ArrayNode)parentTargetNode;
            if (lastPointer.mayMatchElement()) {
                int index = lastPointer.getMatchingIndex();
                if (index >= arrayTargetNode.size() || index < 0) {
                    throw new JsonPatchFormatException("The path '" + pathPointer.toString() + "' points to " + "an invalid index:" + " Must be a positive number and not be greater than the size of the array (" + arrayTargetNode.size() + ").");
                }
                arrayTargetNode.remove(index);
                return rootNode;
            } else {
                if (!lastPointer.mayMatchProperty()) throw new JsonPatchFormatException("The path '" + pathPointer.toString() + "' points to an " + "invalid index:" + " Must be either a positive integer or '-'");
                if (!lastPointer.getMatchingProperty().equals("-")) throw new JsonPatchFormatException("The path '" + pathPointer.toString() + "' points to " + "an invalid index:" + " Must be either a positive integer or '-'");
                if (arrayTargetNode.size() == 0) {
                    throw new JsonPatchFormatException("The path '" + pathPointer.toString() + "' points to " + "an invalid index:" + " Cannot access last element of empty array.");
                }
                arrayTargetNode.remove(arrayTargetNode.size() - 1);
            }
            return rootNode;
        } else {
            if (!parentTargetNode.isObject()) throw new JsonPatchFormatException("The path '" + pathPointer.toString() + "' tries to access a member of a value node.");
            ObjectNode objectParentTargetNode = (ObjectNode)parentTargetNode;
            if (!lastPointer.mayMatchProperty() || lastPointer.getMatchingProperty().trim().equals("-")) throw new JsonPatchFormatException("The path '" + pathPointer.toString() + "' points to an " + "invalid property:" + " Must not be an integer or the special character '-' ");
            JsonNode removed = objectParentTargetNode.remove(lastPointer.getMatchingProperty());
            if (removed != null) return rootNode;
            throw new JsonPatchFormatException("The path '" + pathPointer.toString() + "' points to " + "a non-existent member.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JsonNode put(JsonNode valueNode, JsonPointer pathPointer, JsonNode rootNode) throws JsonPatchFormatException {
        rootNode = rootNode.deepCopy();
        JsonPointer lastPointer = pathPointer.last();
        JsonPointer parentPointer = pathPointer.head();
        if (parentPointer == null) {
            return valueNode;
        }
        JsonNode parentTargetNode = rootNode.at(parentPointer);
        if (parentTargetNode.isArray()) {
            ArrayNode arrayTargetNode = (ArrayNode)parentTargetNode;
            if (lastPointer.mayMatchElement()) {
                int index = lastPointer.getMatchingIndex();
                if (index > arrayTargetNode.size()) {
                    throw new JsonPatchFormatException("The path '" + pathPointer.toString() + "' points to " + "an invalid index:" + " Must not be greater than the size of the array (" + arrayTargetNode.size() + ").");
                }
                arrayTargetNode.insert(index, valueNode);
                return rootNode;
            } else {
                if (!lastPointer.mayMatchProperty()) throw new JsonPatchFormatException("The path '" + pathPointer.toString() + "' points to an " + "invalid index:" + " Must be either a positive integer or '-'");
                if (!lastPointer.getMatchingProperty().equals("-")) throw new JsonPatchFormatException("The path '" + pathPointer.toString() + "' points to " + "an invalid index:" + " Must be either a positive integer or '-'");
                arrayTargetNode.insert(arrayTargetNode.size(), valueNode);
            }
            return rootNode;
        } else if (parentTargetNode.isObject()) {
            ObjectNode objectParentTargetNode = (ObjectNode)parentTargetNode;
            if (!lastPointer.mayMatchProperty() || lastPointer.getMatchingProperty().trim().equals("-")) throw new JsonPatchFormatException("The path '" + pathPointer.toString() + "' points to an " + "invalid property:" + " Must not be an integer or the special character '-' ");
            objectParentTargetNode.set(lastPointer.getMatchingProperty(), valueNode);
            return rootNode;
        } else {
            if (!parentTargetNode.isMissingNode()) throw new JsonPatchFormatException("The parent member '" + parentTargetNode.asText() + "' " + "located at '" + parentPointer + "' is not an object or " + "an array and cannot be added to.");
            throw new JsonPatchFormatException("The path '" + pathPointer.toString() + "' points to an " + "invalid object member." + " Parent member '" + parentPointer.toString() + "' must exist");
        }
    }

    public static boolean test(JsonNode valueNode, JsonPointer pathPointer, JsonNode rootNode) throws JsonPatchFormatException {
        JsonNode targetNode;
        JsonNode parentTargetNode;
        JsonPointer lastPointer = pathPointer.last();
        JsonPointer parentPointer = pathPointer.head();
        if (parentPointer == null) {
            parentTargetNode = rootNode;
            parentPointer = JsonPointer.compile((String)"/");
        } else {
            parentTargetNode = rootNode.at(parentPointer);
        }
        if (parentTargetNode.isArray()) {
            ArrayNode arrayTargetNode = (ArrayNode)parentTargetNode;
            if (lastPointer.mayMatchProperty() && !lastPointer.mayMatchElement()) {
                if (lastPointer.getMatchingProperty().equals("-")) {
                    pathPointer = parentPointer.append(JsonPointer.compile((String)("/" + String.valueOf(arrayTargetNode.size() - 1))));
                } else {
                    throw new JsonPatchFormatException("The path '" + pathPointer.toString() + "' points to " + "an invalid index:" + " Must be either a positive integer or '-'");
                }
            }
        }
        if ((targetNode = rootNode.at(pathPointer)).isMissingNode()) {
            throw new JsonPatchFormatException("The path '" + pathPointer.toString() + "' does not point to an existing value.");
        }
        if (valueNode.getNodeType().equals((Object)targetNode.getNodeType())) {
            if (valueNode.isValueNode()) {
                if (valueNode.isFloatingPointNumber()) {
                    return valueNode.decimalValue().compareTo(targetNode.decimalValue()) == 0;
                }
                return valueNode.equals((Object)targetNode);
            }
            if (valueNode.isContainerNode()) {
                return valueNode.equals((Object)targetNode);
            }
        }
        return false;
    }

    public static JsonNode at(JsonNode rootNode, JsonPointer pathPointer) throws JsonPatchFormatException {
        JsonPointer lastPointer = pathPointer.last();
        JsonPointer parentPointer = pathPointer.head();
        if (parentPointer == null) {
            return rootNode;
        }
        JsonNode parentTargetNode = rootNode.at(parentPointer);
        if (parentTargetNode.isArray()) {
            ArrayNode arrayTargetNode = (ArrayNode)parentTargetNode;
            if (lastPointer.mayMatchElement()) {
                int index = lastPointer.getMatchingIndex();
                if (index > arrayTargetNode.size()) {
                    throw new JsonPatchFormatException("The path '" + pathPointer.toString() + "' points to " + "an invalid index:" + " Must not be greater than the size of the array (" + arrayTargetNode.size() + ").");
                }
                return arrayTargetNode.get(index);
            }
            if (lastPointer.mayMatchProperty()) {
                if (!lastPointer.getMatchingProperty().equals("-")) {
                    throw new JsonPatchFormatException("The path '" + pathPointer.toString() + "' points to " + "an invalid index:" + " Must be either a positive integer or '-'");
                }
                return arrayTargetNode.get(arrayTargetNode.size() - 1);
            }
            throw new JsonPatchFormatException("The path '" + pathPointer.toString() + "' points to an " + "invalid index:" + " Must be either a positive integer or '-'");
        }
        if (parentTargetNode.isObject()) {
            ObjectNode objectParentTargetNode = (ObjectNode)parentTargetNode;
            if (lastPointer.mayMatchProperty() && !lastPointer.getMatchingProperty().trim().equals("-")) {
                return objectParentTargetNode.get(lastPointer.getMatchingProperty());
            }
            throw new JsonPatchFormatException("The path '" + pathPointer.toString() + "' points to an " + "invalid property:" + " Must not be an integer or the special character '-' ");
        }
        if (parentTargetNode.isMissingNode()) {
            throw new JsonPatchFormatException("The path '" + pathPointer.toString() + "' points to an " + "invalid object member." + " Parent member '" + parentPointer.toString() + "' must exist");
        }
        throw new JsonPatchFormatException("The parent member '" + parentTargetNode.asText() + "' " + "located at '" + parentPointer + "' is not an object or " + "an array and cannot be added to.");
    }
}

