/*
 * Decompiled with CFR 0.152.
 */
package io.progix.jackson;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.progix.jackson.JsonPatchOperationDeserializer;
import io.progix.jackson.JsonPatchOperationSerializer;
import io.progix.jackson.JsonPatchOperationType;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(using=JsonPatchOperationDeserializer.class)
@JsonSerialize(using=JsonPatchOperationSerializer.class)
public class JsonPatchOperation {
    private JsonPatchOperationType operation;
    private JsonPointer path;
    private JsonPointer from;
    private JsonNode value;

    public JsonPatchOperation(JsonPatchOperationType operation, JsonPointer path, JsonPointer from) {
        this.operation = operation;
        this.path = path;
        this.from = from;
        this.value = null;
    }

    public JsonPatchOperation(JsonPatchOperationType operation, JsonPointer path) {
        this.operation = operation;
        this.path = path;
    }

    public JsonPatchOperation(JsonPatchOperationType operation, JsonPointer path, JsonNode value) {
        this.operation = operation;
        this.path = path;
        this.value = value;
    }

    public void setOperation(JsonPatchOperationType operation) {
        this.operation = operation;
    }

    public void setPath(JsonPointer path) {
        this.path = path;
    }

    public void setFrom(JsonPointer from) {
        this.from = from;
    }

    public void setValue(JsonNode value) {
        this.value = value;
    }

    public JsonPatchOperationType getOperation() {
        return this.operation;
    }

    public JsonPointer getPath() {
        return this.path;
    }

    public JsonPointer getFrom() {
        return this.from;
    }

    public JsonNode getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonPatchOperation that = (JsonPatchOperation)o;
        if (this.from != null ? !this.from.equals((Object)that.from) : that.from != null) {
            return false;
        }
        if (this.operation != that.operation) {
            return false;
        }
        if (this.path != null ? !this.path.equals((Object)that.path) : that.path != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals((Object)that.value) : that.value != null);
    }

    public int hashCode() {
        int result = this.operation != null ? this.operation.hashCode() : 0;
        result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
        result = 31 * result + (this.from != null ? this.from.hashCode() : 0);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "JsonPatchOperation{operation=" + (Object)((Object)this.operation) + ", path=" + this.path + ", from=" + this.from + ", value=" + this.value + '}';
    }
}

