/*
 * Decompiled with CFR 0.152.
 */
package io.progix.jackson;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import io.progix.jackson.JsonPatchOperation;
import io.progix.jackson.JsonPatchUtil;
import io.progix.jackson.exceptions.JsonPatchAddFailedException;
import io.progix.jackson.exceptions.JsonPatchCopyFailedException;
import io.progix.jackson.exceptions.JsonPatchFailedException;
import io.progix.jackson.exceptions.JsonPatchFormatException;
import io.progix.jackson.exceptions.JsonPatchMoveFailedException;
import io.progix.jackson.exceptions.JsonPatchRemoveFailedException;
import io.progix.jackson.exceptions.JsonPatchReplaceFailedException;
import io.progix.jackson.exceptions.JsonPatchTestFailedException;

public class JsonPatch {
    public static JsonNode apply(JsonPatchOperation[] patchOperations, JsonNode rootDocument) throws JsonPatchFailedException {
        block8: for (JsonPatchOperation instruction : patchOperations) {
            switch (instruction.getOperation()) {
                case ADD: {
                    rootDocument = JsonPatch.add(instruction.getPath(), instruction.getValue(), rootDocument);
                    continue block8;
                }
                case REMOVE: {
                    rootDocument = JsonPatch.remove(instruction.getPath(), rootDocument);
                    continue block8;
                }
                case REPLACE: {
                    rootDocument = JsonPatch.replace(instruction.getPath(), instruction.getValue(), rootDocument);
                    continue block8;
                }
                case COPY: {
                    rootDocument = JsonPatch.copy(instruction.getPath(), instruction.getFrom(), rootDocument);
                    continue block8;
                }
                case TEST: {
                    JsonPatch.test(instruction.getPath(), instruction.getValue(), rootDocument);
                    continue block8;
                }
                case MOVE: {
                    rootDocument = JsonPatch.move(instruction.getPath(), instruction.getFrom(), rootDocument);
                    continue block8;
                }
                default: {
                    throw new JsonPatchFailedException(instruction, "Operation '" + (Object)((Object)instruction.getOperation()) + "' is not valid.");
                }
            }
        }
        return rootDocument;
    }

    public static JsonNode add(JsonPointer path, JsonNode value, JsonNode document) throws JsonPatchFailedException {
        try {
            document = JsonPatchUtil.put(value, path, document);
        }
        catch (JsonPatchFormatException e) {
            throw new JsonPatchAddFailedException(path, value, (Throwable)e);
        }
        return document;
    }

    public static JsonNode copy(JsonPointer path, JsonPointer from, JsonNode document) throws JsonPatchFailedException {
        try {
            JsonNode valueNode = JsonPatchUtil.at(document, from);
            document = JsonPatchUtil.put(valueNode, path, document);
        }
        catch (JsonPatchFormatException e) {
            throw new JsonPatchCopyFailedException(path, from, (Throwable)e);
        }
        return document;
    }

    public static JsonNode move(JsonPointer path, JsonPointer from, JsonNode document) throws JsonPatchFailedException {
        try {
            JsonNode valueNode = JsonPatchUtil.at(document, from);
            document = JsonPatchUtil.remove(from, document);
            document = JsonPatchUtil.put(valueNode, path, document);
        }
        catch (JsonPatchFormatException e) {
            throw new JsonPatchMoveFailedException(path, from, (Throwable)e);
        }
        return document;
    }

    public static JsonNode remove(JsonPointer path, JsonNode document) throws JsonPatchFailedException {
        try {
            document = JsonPatchUtil.remove(path, document);
        }
        catch (JsonPatchFormatException e) {
            throw new JsonPatchRemoveFailedException(path, (Throwable)e);
        }
        return document;
    }

    public static JsonNode replace(JsonPointer path, JsonNode value, JsonNode document) throws JsonPatchFailedException {
        try {
            document = JsonPatchUtil.remove(path, document);
            document = JsonPatchUtil.put(value, path, document);
        }
        catch (JsonPatchFormatException e) {
            throw new JsonPatchReplaceFailedException(path, value, (Throwable)e);
        }
        return document;
    }

    public static void test(JsonPointer path, JsonNode value, JsonNode document) throws JsonPatchFailedException {
        try {
            if (!JsonPatchUtil.test(value, path, document)) {
                JsonNode actual = JsonPatchUtil.at(document, path);
                throw new JsonPatchTestFailedException(path, (Object)value, actual);
            }
        }
        catch (JsonPatchFormatException e) {
            throw new JsonPatchTestFailedException(path, value, (Throwable)e);
        }
    }
}

