/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.rt.client.junit;

import io.probedock.client.common.config.ProbeConfigurationException;
import io.probedock.client.common.utils.TestResultDataUtils;
import io.probedock.client.junit.AbstractProbeListener;
import io.probedock.rt.client.Configuration;
import io.probedock.rt.client.Listener;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;

public class ProbeRTListener
extends AbstractProbeListener {
    private static final Logger LOGGER = Logger.getLogger(ProbeRTListener.class.getCanonicalName());
    private static final Configuration rtConfiguration = Configuration.getInstance();
    private final Listener rtListener = new Listener();
    private final Set<String> testFailures = new HashSet<String>();
    private final Set<String> testIgnored = new HashSet<String>();
    private String projectApiId;
    private String projectVersion;

    public ProbeRTListener() {
        try {
            this.projectApiId = configuration.getProjectApiId();
            this.projectVersion = configuration.getProjectVersion();
        }
        catch (ProbeConfigurationException pce) {
            LOGGER.warning("Unable to retrieve the project API ID, the probedock.yml project configuration is probably missing. Dummy data for project API ID and version will be used in place.");
            this.projectApiId = "Any";
            this.projectVersion = "Any";
        }
    }

    public void testRunStarted(Description description) throws Exception {
        super.testRunStarted(description);
        if (!rtConfiguration.isEnabled()) {
            return;
        }
        this.rtListener.testRunStart(this.projectApiId, this.projectVersion, TestResultDataUtils.getCategory((io.probedock.client.common.config.Configuration)configuration, null, null, (String)this.getCategory()));
    }

    public void testRunFinished(Result result) throws Exception {
        if (!rtConfiguration.isEnabled()) {
            return;
        }
        long runEndedDate = System.currentTimeMillis();
        this.rtListener.testRunEnd(this.projectApiId, this.projectVersion, TestResultDataUtils.getCategory((io.probedock.client.common.config.Configuration)configuration, null, null, (String)this.getCategory()), Long.valueOf(runEndedDate - this.runStartedDate));
    }

    public void testStarted(Description description) throws Exception {
        super.testStarted(description);
        if (!rtConfiguration.isEnabled()) {
            return;
        }
        this.testStartDates.put(this.getFingerprint(description), System.currentTimeMillis());
    }

    public void testFinished(Description description) throws Exception {
        super.testFinished(description);
        if (!rtConfiguration.isEnabled()) {
            return;
        }
        String fingerprint = this.getFingerprint(description);
        if (!this.testIgnored.contains(fingerprint) && !this.testFailures.contains(fingerprint)) {
            this.rtListener.testResult(this.createTestResult(this.getFingerprint(description), description, this.getMethodAnnotation(description), this.getClassAnnotation(description), true, null), this.projectApiId, this.projectVersion, TestResultDataUtils.getCategory((String)this.getPackage(description.getTestClass()), (io.probedock.client.common.config.Configuration)configuration, null, null, (String)this.getCategory()));
        }
    }

    public void testFailure(Failure failure) throws Exception {
        super.testFailure(failure);
        if (!rtConfiguration.isEnabled()) {
            return;
        }
        Description description = failure.getDescription();
        String fingerprint = this.getFingerprint(description);
        if (this.testIgnored.contains(fingerprint)) {
            return;
        }
        this.testFailures.add(fingerprint);
        this.rtListener.testResult(this.createTestResult(this.getFingerprint(description), description, this.getMethodAnnotation(description), this.getClassAnnotation(description), false, this.createAndlogStackTrace(failure)), this.projectApiId, this.projectVersion, TestResultDataUtils.getCategory((String)this.getPackage(description.getTestClass()), (io.probedock.client.common.config.Configuration)configuration, null, null, (String)this.getCategory()));
    }

    public void testAssumptionFailure(Failure failure) {
        super.testAssumptionFailure(failure);
        this.registerIgnoredTest(failure.getDescription());
    }

    public void testIgnored(Description description) throws Exception {
        super.testIgnored(description);
        this.registerIgnoredTest(description);
    }

    private void registerIgnoredTest(Description description) {
        if (rtConfiguration.isEnabled()) {
            this.testIgnored.add(this.getFingerprint(description));
        }
    }
}

