/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.rt.client;

import com.github.nkzawa.emitter.Emitter;
import com.github.nkzawa.socketio.client.IO;
import com.github.nkzawa.socketio.client.Socket;
import io.probedock.client.common.model.ProbeTestRun;
import io.probedock.client.common.model.v1.TestResult;
import io.probedock.client.common.model.v1.TestRun;
import io.probedock.client.core.filters.FilterDefinition;
import io.probedock.client.core.serializer.json.JsonSerializer;
import io.probedock.rt.client.Callback;
import io.probedock.rt.client.Configuration;
import io.probedock.rt.client.FilterAcknowledger;
import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class Connector
implements Serializable {
    public static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(Connector.class.getCanonicalName());
    private final Socket socket = this.createConnectedSocket(Configuration.getInstance().getUrl());
    private static final Connector instance = new Connector();

    private Connector() {
    }

    public static Connector getInstance() {
        return instance;
    }

    private boolean isStarted() {
        return this.socket != null && this.socket.connected();
    }

    public void notifyStart(String projectApiId, String projectVersion, String category) {
        block4: {
            try {
                if (this.isStarted()) {
                    JSONObject startNotification = new JSONObject().put("project", (Object)new JSONObject().put("apiId", (Object)projectApiId).put("version", (Object)projectVersion)).put("category", (Object)category);
                    this.socket.emit("run:start", new Object[]{startNotification});
                } else {
                    LOGGER.log(Level.WARNING, "Probe Dock RT is not available to send the start notification");
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, "Unable to send the start notification to the agent. Cause: " + e.getMessage());
                if (LOGGER.getLevel() != Level.FINEST) break block4;
                LOGGER.log(Level.FINEST, "Exception: ", e);
            }
        }
    }

    public void notifyTestResult(TestResult result, String projectApiId, String projectVersion, String category) {
        block3: {
            try {
                if (this.isStarted()) {
                    JSONObject testResult = new JSONObject().put("k", (Object)result.getKey()).put("f", (Object)result.getFingerprint()).put("n", (Object)result.getName()).put("j", (Object)projectApiId).put("v", (Object)projectVersion).put("e", result.isActive() != null ? result.isActive() : true).put("p", result.isPassed()).put("d", result.getDuration()).put("m", (Object)result.getMessage()).put("c", (Object)(result.getCategory() != null && !result.getCategory().isEmpty() ? result.getCategory() : category)).put("g", (Object)new JSONArray((Collection)result.getTags())).put("t", (Object)new JSONArray((Collection)result.getTickets())).put("a", (Object)new JSONObject(result.getData()));
                    this.socket.emit("run:test:result", new Object[]{testResult});
                }
            }
            catch (Exception e) {
                if (LOGGER.getLevel() != Level.FINEST) break block3;
                LOGGER.log(Level.FINEST, "Unable to send the test result notification to the agent. Cause: " + e.getMessage());
                LOGGER.log(Level.FINEST, "Exception: ", e);
            }
        }
    }

    public void notifyEnd(String projectApiId, String projectVersion, String category, long duration) {
        block4: {
            try {
                if (this.isStarted()) {
                    JSONObject endNotification = new JSONObject().put("project", (Object)new JSONObject().put("apiId", (Object)projectApiId).put("version", (Object)projectVersion)).put("category", (Object)category).put("duration", duration);
                    this.socket.emit("run:end", new Object[]{endNotification});
                } else {
                    LOGGER.log(Level.WARNING, "Probe Dock RT is not available to send the end notification");
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, "Unable to send the end notification to the agent. Cause: " + e.getMessage());
                if (LOGGER.getLevel() != Level.FINEST) break block4;
                LOGGER.log(Level.FINEST, "Exception:", e);
            }
        }
    }

    public void send(TestRun testRun) {
        block4: {
            try {
                if (this.isStarted()) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    new JsonSerializer().serializePayload(new OutputStreamWriter(baos), (ProbeTestRun)testRun, false);
                    this.socket.emit("payload", new Object[]{new String(baos.toByteArray())});
                } else {
                    LOGGER.log(Level.WARNING, "Probe Dock RT is not available to send the test results");
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Unable to send the result to the agent. Cause: " + e.getMessage());
                if (LOGGER.getLevel() != Level.FINEST) break block4;
                LOGGER.log(Level.FINEST, "Exception: ", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FilterDefinition> getFilters() {
        block7: {
            try {
                if (!this.isStarted()) break block7;
                final FilterAcknowledger acknowledger = new FilterAcknowledger();
                new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            LOGGER.finest("Retrieve filters");
                            Connector.this.socket.emit("filters:get", new Object[]{acknowledger});
                        }
                        catch (Exception e) {
                            LOGGER.finest("Unable to get the filters: " + e.getMessage());
                            FilterAcknowledger filterAcknowledger = acknowledger;
                            synchronized (filterAcknowledger) {
                                acknowledger.notify();
                            }
                        }
                    }
                }).start();
                FilterAcknowledger filterAcknowledger = acknowledger;
                synchronized (filterAcknowledger) {
                    acknowledger.wait();
                }
                if (!acknowledger.hasFilters()) {
                    for (FilterDefinition filter : acknowledger.getFilters()) {
                        LOGGER.info("Filter element: " + filter);
                    }
                }
                return acknowledger.getFilters();
            }
            catch (Exception e) {
                LOGGER.warning("Unable to retrieve the filters from the agent. Cause: " + e.getMessage());
                e.printStackTrace();
                if (LOGGER.getLevel() != Level.FINEST) break block7;
                LOGGER.log(Level.FINEST, "Exception: ", e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Socket createConnectedSocket(String url) {
        try {
            final Socket initSocket = IO.socket((String)url);
            Callback callback = new Callback();
            initSocket.on("connect", (Emitter.Listener)callback);
            initSocket.on("connect_error", (Emitter.Listener)callback);
            initSocket.on("connect_timeout", (Emitter.Listener)callback);
            initSocket.on("connect_error", (Emitter.Listener)callback);
            initSocket.on("disconnect", (Emitter.Listener)callback);
            initSocket.on("error", (Emitter.Listener)callback);
            LOGGER.finest("Connection to Probe Dock RT");
            new Thread(new Runnable(){

                @Override
                public void run() {
                    initSocket.connect();
                }
            }).start();
            Callback callback2 = callback;
            synchronized (callback2) {
                callback.wait();
            }
            if (!initSocket.connected()) {
                LOGGER.warning("Probe Dock RT is not available");
                return null;
            }
            return initSocket;
        }
        catch (InterruptedException | URISyntaxException e) {
            LOGGER.log(Level.WARNING, "Unknown error", e);
            return null;
        }
    }
}

