/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.rt.client;

import io.probedock.client.common.config.ScmInfo;
import io.probedock.client.common.config.ServerListConfiguration;
import io.probedock.client.common.config.YamlConfigurationFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.ConfigurationException;

public class Configuration {
    private static final Logger LOGGER = Logger.getLogger(Configuration.class.getCanonicalName());
    private static final String BASE_CONFIG_PATH = ".probedock/probedock-rt.yml";
    private static final String P_ROOT_NODE_NAME = "probedock-rt";
    private static final String P_PDRT_ENABLE = "probedock-rt.enable";
    private static final String P_PDRT_HOST = "probedock-rt.host";
    private static final String P_PDRT_PORT = "probedock-rt.port";
    private static Configuration instance;
    protected CompositeConfiguration config = new CompositeConfiguration();
    private boolean enabled = true;

    protected Configuration() {
        try {
            this.config.addConfiguration((org.apache.commons.configuration.Configuration)new YamlConfigurationFile(BASE_CONFIG_PATH, P_ROOT_NODE_NAME, new ServerListConfiguration(), new ScmInfo()));
        }
        catch (ConfigurationException ce) {
            if (LOGGER.getLevel() == Level.FINEST) {
                LOGGER.log(Level.FINEST, "Unable to load the probe dock rt configuration.", ce);
            }
            LOGGER.log(Level.WARNING, "Unable to load the probe dock rt configuration due to: " + ce.getMessage());
        }
    }

    public static Configuration getInstance() {
        if (instance == null) {
            instance = new Configuration();
        }
        return instance;
    }

    private String getMandatory(String name) {
        if (!this.config.containsKey(name)) {
            throw new RuntimeException(name + " parameter is missing.");
        }
        return this.config.getString(name);
    }

    public boolean isEnabled() {
        return this.config.getBoolean(P_PDRT_ENABLE, true);
    }

    public String getUrl() {
        return "http://" + this.config.getString(P_PDRT_HOST, "127.0.0.1") + ":" + this.config.getInteger(P_PDRT_PORT, Integer.valueOf(1337));
    }
}

