/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.maven.plugin.uuid;

import java.util.UUID;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="generate", defaultPhase=LifecyclePhase.INITIALIZE, requiresProject=true)
public class ReportUuidMojo
extends AbstractMojo {
    @Parameter(defaultValue="probedock.report.uuid")
    private String propertyName;
    @Parameter(defaultValue="${session}", required=true)
    private MavenSession session;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String generatedUuid = this.session.getTopLevelProject().getProperties().getProperty(this.propertyName);
        if (generatedUuid == null || generatedUuid.isEmpty()) {
            generatedUuid = UUID.randomUUID().toString();
            this.session.getTopLevelProject().getProperties().setProperty(this.propertyName, generatedUuid);
        }
        this.session.getCurrentProject().getProperties().setProperty(this.propertyName, generatedUuid);
    }
}

