/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.maven.plugin.uid;

import java.util.UUID;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="generate", defaultPhase=LifecyclePhase.INITIALIZE, requiresProject=true)
public class ReportUidMojo
extends AbstractMojo {
    @Parameter(defaultValue="probedock.report.uid")
    private String propertyName;
    @Parameter(defaultValue="${session}", required=true)
    private MavenSession session;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String generatedUid = this.session.getSystemProperties().getProperty("PROBEDOCK_TEST_REPORT_UID");
        if (generatedUid == null || generatedUid.isEmpty()) {
            generatedUid = this.session.getTopLevelProject().getProperties().getProperty(this.propertyName);
        }
        if (generatedUid == null || generatedUid.isEmpty()) {
            generatedUid = UUID.randomUUID().toString();
            this.session.getTopLevelProject().getProperties().setProperty(this.propertyName, generatedUid);
        }
        this.session.getCurrentProject().getProperties().setProperty(this.propertyName, generatedUid);
    }
}

