/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.maven.plugin.glassfish.model;

import io.probedock.maven.plugin.glassfish.model.AdminObject;
import io.probedock.maven.plugin.glassfish.model.ConnectionFactory;
import io.probedock.maven.plugin.glassfish.model.ConnectorConnectionPool;
import io.probedock.maven.plugin.glassfish.model.ConnectorResource;
import io.probedock.maven.plugin.glassfish.model.JdbcResource;
import io.probedock.maven.plugin.glassfish.model.JmsResource;
import io.probedock.maven.plugin.glassfish.model.Property;
import io.probedock.maven.plugin.glassfish.model.ResourceAdapter;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.util.Arrays;
import java.util.Set;
import org.apache.maven.plugins.annotations.Parameter;

public class Domain {
    @Parameter
    private String host;
    @Parameter(defaultValue="${glassfish.home}/domains")
    private File directory;
    @Parameter(required=true)
    private String name;
    @Parameter(required=true)
    private int adminPort;
    @Parameter
    private int httpPort;
    @Parameter
    private int httpsPort;
    @Parameter
    private int iiopPort;
    @Parameter
    private int iiopsPort;
    @Parameter
    private int iiopsmPort;
    @Parameter
    private int jmsPort;
    @Parameter
    private int jmxPort;
    @Parameter
    private int debuggerPort;
    @Parameter
    private int osgiShellTelnetPort;
    @Parameter(defaultValue="false")
    private boolean reuse;
    @Parameter
    private Set<String> createJvmOptions;
    @Parameter
    private Set<String> deleteJvmOption;
    @Parameter
    private Set<Property> loggingAttributes;
    @Parameter
    private Set<Property> properties;
    @Parameter
    private Set<ConnectionFactory> connectionFactories;
    @Parameter
    private Set<ConnectorConnectionPool> connectorConnectionPools;
    @Parameter
    private Set<ConnectorResource> connectorResources;
    @Parameter
    private Set<JmsResource> jmsResources;
    @Parameter
    private Set<JdbcResource> jdbcResources;
    @Parameter
    private Set<ResourceAdapter> resourceAdapters;
    @Parameter
    private Set<AdminObject> adminObjects;

    public String getName() {
        return this.name;
    }

    public int getAdminPort() {
        return this.adminPort;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public int getHttpsPort() {
        return this.httpsPort;
    }

    public int getIiopPort() {
        return this.iiopPort;
    }

    public int getIiopsPort() {
        return this.iiopsPort;
    }

    public int getIiopsmPort() {
        return this.iiopsmPort;
    }

    public int getJmsPort() {
        return this.jmsPort;
    }

    public int getJmxPort() {
        return this.jmxPort;
    }

    public int getDebuggerPort() {
        return this.debuggerPort;
    }

    public int getOsgiShellTelnetPort() {
        return this.osgiShellTelnetPort;
    }

    public boolean isReuse() {
        return this.reuse;
    }

    public Set<String> getCreateJvmOptions() {
        return this.createJvmOptions;
    }

    public Set<String> getDeleteJvmOption() {
        return this.deleteJvmOption;
    }

    public Set<Property> getLoggingAttributes() {
        return this.loggingAttributes;
    }

    public Set<Property> getProperties() {
        return this.properties;
    }

    public Set<ConnectionFactory> getConnectionFactories() {
        return this.connectionFactories;
    }

    public Set<JmsResource> getJmsResources() {
        return this.jmsResources;
    }

    public Set<JdbcResource> getJdbcResources() {
        return this.jdbcResources;
    }

    public Set<ConnectorConnectionPool> getConnectorConnectionPools() {
        return this.connectorConnectionPools;
    }

    public void setConnectorConnectionPools(Set<ConnectorConnectionPool> connectorConnectionPools) {
        this.connectorConnectionPools = connectorConnectionPools;
    }

    public boolean hasConnectorConnectionPools() {
        return this.connectorConnectionPools != null && !this.connectorConnectionPools.isEmpty();
    }

    public Set<ConnectorResource> getConnectorResources() {
        return this.connectorResources;
    }

    public void setConnectorResources(Set<ConnectorResource> connectorResources) {
        this.connectorResources = connectorResources;
    }

    public boolean hasConnectorResources() {
        return this.connectorResources != null && !this.connectorResources.isEmpty();
    }

    public Set<ResourceAdapter> getResourceAdapters() {
        return this.resourceAdapters;
    }

    public void setResourceAdapters(Set<ResourceAdapter> resourceAdapters) {
        this.resourceAdapters = resourceAdapters;
    }

    public boolean hasResourceAdapters() {
        return this.resourceAdapters != null && !this.resourceAdapters.isEmpty();
    }

    public Set<AdminObject> getAdminObjects() {
        return this.adminObjects;
    }

    public void setAdminObjects(Set<AdminObject> adminObjects) {
        this.adminObjects = adminObjects;
    }

    public boolean hasAdminObjects() {
        return this.adminObjects != null && !this.adminObjects.isEmpty();
    }

    public boolean exists() {
        return this.host == null || "localhost".equals(this.host) ? this.directory.exists() && Arrays.asList(this.directory.list()).contains(this.name) : false;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public boolean isStarted() {
        try {
            Socket socket = new Socket(this.host, this.adminPort);
            socket.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        String props = null;
        if (this.properties != null) {
            for (Property p : this.properties) {
                builder.append(p).append(", ");
            }
            props = builder.toString().replaceAll(", $", "");
        }
        return "createJvmOptions=" + this.createJvmOptions + ", " + "adminPort=" + this.adminPort + ", " + "connectionFactories=" + this.connectionFactories + ", " + "debuggerPort=" + this.debuggerPort + ", " + "deleteJvmOptions=" + this.deleteJvmOption + ", " + "directory=" + this.directory + ", " + "host=" + this.host + ", " + "httpPort=" + this.httpPort + ", " + "httpsPort=" + this.httpsPort + ", " + "iiopPort=" + this.iiopPort + ", " + "iiopsPort=" + this.iiopsPort + ", " + "iipsmPort=" + this.iiopsmPort + ", " + "jdbcResources=" + this.jdbcResources + ", " + "jmsPort=" + this.jmsPort + ", " + "jmsResources" + this.jmsResources + ", " + "jmxPort=" + this.jmxPort + ", " + "loggingAttributes=" + this.loggingAttributes + ", " + "name=" + this.name + ", " + "reuse=" + this.reuse + ", " + "properties=" + props;
    }
}

