/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.maven.plugin.glassfish.model;

import io.probedock.maven.plugin.glassfish.model.DeployConfiguration;
import io.probedock.maven.plugin.glassfish.model.Domain;
import io.probedock.maven.plugin.glassfish.model.Glassfish;
import io.probedock.maven.plugin.glassfish.model.RedeployConfiguration;
import io.probedock.maven.plugin.glassfish.model.UndeployConfiguration;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.maven.plugin.logging.Log;

public class Configuration {
    private Glassfish glassfish;
    private Domain domain;
    private DeployConfiguration deployConfiguration;
    private RedeployConfiguration redeployConfiguration;
    private UndeployConfiguration undeployConfiguration;
    private InetAddress domainAddress;
    private Log log;

    public Configuration(Log log, Glassfish glassfish, Domain domain) {
        this.glassfish = glassfish;
        this.domain = domain;
        this.log = log;
        try {
            this.domainAddress = InetAddress.getByName(domain.getHost());
        }
        catch (UnknownHostException uhe) {
            throw new IllegalArgumentException(uhe);
        }
    }

    public Configuration(Log log, Glassfish glassfish, Domain domain, DeployConfiguration deployConfiguration) {
        this(log, glassfish, domain);
        this.deployConfiguration = deployConfiguration;
    }

    public Configuration(Log log, Glassfish glassfish, Domain domain, RedeployConfiguration redeployConfiguration) {
        this(log, glassfish, domain);
        this.redeployConfiguration = redeployConfiguration;
    }

    public Configuration(Log log, Glassfish glassfish, Domain domain, UndeployConfiguration undeployConfiguration) {
        this(log, glassfish, domain);
        this.undeployConfiguration = undeployConfiguration;
    }

    public Domain getDomain() {
        return this.domain;
    }

    public Glassfish getGlassfish() {
        return this.glassfish;
    }

    public DeployConfiguration getDeployConfiguration() {
        return this.deployConfiguration;
    }

    public void setDeployConfiguration(DeployConfiguration deployConfiguration) {
        this.deployConfiguration = deployConfiguration;
    }

    public RedeployConfiguration getRedeployConfiguration() {
        return this.redeployConfiguration;
    }

    public UndeployConfiguration getUndeployConfiguration() {
        return this.undeployConfiguration;
    }

    public boolean isLocalDomain() {
        return this.domainAddress.isAnyLocalAddress();
    }

    public Log getLog() {
        return this.log;
    }

    public String toString() {
        return "deploytConfiguration=" + this.deployConfiguration + ", " + "domain=" + this.domain + ", " + "glassfish=" + this.glassfish + ", " + "redeployConfiguration=" + this.redeployConfiguration + ", " + "undeployConfiguration" + this.undeployConfiguration;
    }
}

