/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.maven.plugin.glassfish.macro;

import io.probedock.maven.plugin.glassfish.command.CommandFactory;
import io.probedock.maven.plugin.glassfish.macro.AbstractMacro;
import io.probedock.maven.plugin.glassfish.macro.MacroCommand;
import io.probedock.maven.plugin.glassfish.model.Configuration;
import io.probedock.maven.plugin.glassfish.model.ConnectionFactory;
import io.probedock.maven.plugin.glassfish.model.JmsHost;
import io.probedock.maven.plugin.glassfish.model.JmsResource;
import io.probedock.maven.plugin.glassfish.model.Property;

public class JmsResourcesMacro
extends AbstractMacro {
    public JmsResourcesMacro(Configuration configuration) {
        super(configuration);
        if (configuration.getGlassfish().isDeleteDefaultJmsHost()) {
            this.registerCommand(new MacroCommand(CommandFactory.buildDeleteDefaultJmsHost(configuration), "Delete the default JMS Host."));
        }
        if (configuration.getGlassfish().hasJmsHosts()) {
            for (JmsHost jmsHost : configuration.getGlassfish().getJmsHosts()) {
                this.registerCommand(new MacroCommand(CommandFactory.buildCreateJmsHostCommand(configuration, jmsHost), "Create the JMS Host [" + jmsHost.getName() + "]."));
                if (!jmsHost.hasProperties()) continue;
                for (Property property : jmsHost.getProperties()) {
                    this.registerCommand(new MacroCommand(CommandFactory.buildSetJmsHostAttributeCommand(configuration, jmsHost, property), "Set the JMS Host [" + jmsHost.getName() + "] attribute [" + property.getName() + "]."));
                }
            }
        }
        if (configuration.getGlassfish().getJmsService() != null && configuration.getGlassfish().getJmsService().hasProperties()) {
            for (Property property : configuration.getGlassfish().getJmsService().getProperties()) {
                this.registerCommand(new MacroCommand(CommandFactory.buildSetJmsServiceAttributeCommand(configuration, property), "Set the JMS service attribute [" + property.getName() + "]."));
            }
        }
        if (configuration.getDomain() != null) {
            if (configuration.getDomain().getConnectionFactories() != null) {
                for (ConnectionFactory connectionFactory : configuration.getDomain().getConnectionFactories()) {
                    this.registerCommand(new MacroCommand(CommandFactory.buildCreateJmsResourceCommand(configuration, connectionFactory), "Creation of the connection factory [" + connectionFactory.getJndiName() + "]."));
                }
            }
            if (configuration.getDomain().getJmsResources() != null) {
                for (JmsResource resource : configuration.getDomain().getJmsResources()) {
                    if (resource.isCreatePhysicalDestination()) {
                        this.registerCommand(new MacroCommand(CommandFactory.buildCreateJmsDestination(configuration, resource), "Creation of the JMS physical destination [" + resource.getJndiName() + "]."));
                    }
                    this.registerCommand(new MacroCommand(CommandFactory.buildCreateJmsResourceCommand(configuration, resource), "Creation of the JMS resource [" + resource.getJndiName() + "]."));
                }
            }
        }
    }
}

