/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.maven.plugin.glassfish.macro;

import io.probedock.maven.plugin.glassfish.command.CommandFactory;
import io.probedock.maven.plugin.glassfish.macro.AbstractMacro;
import io.probedock.maven.plugin.glassfish.macro.MacroCommand;
import io.probedock.maven.plugin.glassfish.model.Configuration;
import io.probedock.maven.plugin.glassfish.model.JdbcResource;

public class JdbcResourcesMacro
extends AbstractMacro {
    public JdbcResourcesMacro(Configuration configuration) {
        super(configuration);
        if (configuration.getDomain() != null && configuration.getDomain().getJdbcResources() != null) {
            for (JdbcResource resource : configuration.getDomain().getJdbcResources()) {
                this.registerCommand(new MacroCommand(CommandFactory.buildCreatJdbcConnectionPool(configuration, resource), "Create JDBC connection pool [" + resource.getJndiName() + "]."));
                if (resource.getTimerPool() != null && resource.getTimerPool().booleanValue()) {
                    this.registerCommand(new MacroCommand(CommandFactory.buildSetTimerResourceConnectionPool(configuration, resource), "Update jdbc/__TimerPool resource with connection pool [" + resource.getJndiName() + "]."));
                    continue;
                }
                this.registerCommand(new MacroCommand(CommandFactory.buildCreateJdbcResource(configuration, resource), "Create JDBC resource [" + resource.getJndiName() + "]."));
            }
        }
    }
}

