/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.maven.plugin.glassfish.macro;

import io.probedock.maven.plugin.glassfish.command.CommandFactory;
import io.probedock.maven.plugin.glassfish.macro.AbstractMacro;
import io.probedock.maven.plugin.glassfish.macro.AdminObjectsMacro;
import io.probedock.maven.plugin.glassfish.macro.ConnectorConnectionPoolsMacro;
import io.probedock.maven.plugin.glassfish.macro.ConnectorResourceMacro;
import io.probedock.maven.plugin.glassfish.macro.JdbcResourcesMacro;
import io.probedock.maven.plugin.glassfish.macro.JmsResourcesMacro;
import io.probedock.maven.plugin.glassfish.macro.JvmOptionsMacro;
import io.probedock.maven.plugin.glassfish.macro.MacroCommand;
import io.probedock.maven.plugin.glassfish.macro.MacroMacroCommand;
import io.probedock.maven.plugin.glassfish.macro.ResourceAdaptersMacro;
import io.probedock.maven.plugin.glassfish.macro.SetCommandMacro;
import io.probedock.maven.plugin.glassfish.model.Configuration;

public class CreateDomainMacro
extends AbstractMacro {
    public CreateDomainMacro(Configuration configuration) {
        super(configuration);
        if (this.isLocalDomain()) {
            throw new UnsupportedOperationException("The creation of a domain on a remote host is not supported at the moment.");
        }
        if (configuration.getDomain().exists()) {
            if (configuration.getDomain().isReuse()) {
                this.registerCommand(new MacroCommand("Domain exists. Reusing it."));
            } else {
                if (configuration.getDomain().isStarted()) {
                    this.registerCommand(new MacroCommand(CommandFactory.buildStopDomainCommand(configuration), "Domain is started. Stopping it."));
                }
                this.registerCommand(new MacroCommand(CommandFactory.buildDeleteDomainCommand(configuration), "Domain exists. Deleting it."));
            }
        }
        this.registerCommand(new MacroCommand(CommandFactory.buildCreateDomainCommand(configuration), "Creating domain."));
        this.registerCommand(new MacroCommand(CommandFactory.buildStartDomainCommand(configuration), "Starting domain."));
        this.registerCommand(new MacroMacroCommand(new JvmOptionsMacro(configuration), "Managing the JVM options."));
        this.registerCommand(new MacroMacroCommand(new SetCommandMacro(configuration), "Setting additional domain properties"));
        this.registerCommand(new MacroCommand(CommandFactory.buildSetLoggingAttributesCommand(configuration), "Setting the logging attributes."));
        this.registerCommand(new MacroMacroCommand(new JmsResourcesMacro(configuration), "Managing JMS Resources."));
        this.registerCommand(new MacroMacroCommand(new JdbcResourcesMacro(configuration), "Managing JDBC Resources."));
        this.registerCommand(new MacroMacroCommand(new ResourceAdaptersMacro(configuration), "Managing deployment of Resource Adapter"));
        this.registerCommand(new MacroMacroCommand(new ConnectorConnectionPoolsMacro(configuration), "Creating Connectors Connection Pools."));
        this.registerCommand(new MacroMacroCommand(new ConnectorResourceMacro(configuration), "Creating Connectors Resources."));
        this.registerCommand(new MacroMacroCommand(new AdminObjectsMacro(configuration), "Creating Admin Object."));
        this.registerCommand(new MacroCommand(CommandFactory.buildStopDomainCommand(configuration), "Stopping domain."));
    }
}

